<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="text" omit-xml-declaration="yes" indent="no"/>
	<xsl:variable name="newline" select="'&#10;'"/>
	<xsl:variable name="openQuote" select="'&quot;'"/>
	<xsl:variable name="closeQuote" select="'&quot;;'"/>
	<xsl:variable name="closeOpenQuote" select="'&quot;;&quot;'"/>
	<xsl:template match="/">
		<xsl:text>SOURCE_DATASOURCE_ID;</xsl:text>
		<xsl:text>SOURCE_ID;</xsl:text>
		<xsl:text>SOURCE_DATA;</xsl:text>
		<xsl:text>PRE_PARSED_SOURCE_DATA;</xsl:text>
		<xsl:text>PARSED_SCIENTIFIC_NAME;</xsl:text>
		<xsl:text>PARSED_AUTHORITY;</xsl:text>
		<xsl:text>PARSER;</xsl:text>
		<xsl:text>POST_PARSED_SCIENTIFIC_NAME;</xsl:text>
		<xsl:text>POST_PARSED_AUTHORITY;</xsl:text>
		<xsl:text>MATCHING_SCORE;</xsl:text>
		<xsl:text>TARGET_DATA_SOURCE;</xsl:text>
		<xsl:text>TARGET_DATA_ID;</xsl:text>
		<xsl:text>TARGET_DATA_SCIENTIFIC_NAME;</xsl:text>
		<xsl:text>TARGET_DATA_AUTHORITY;</xsl:text>
		<xsl:text>TARGET_DATA_KINGDOM;</xsl:text>
		<xsl:text>TARGET_DATA_PHYLUM;</xsl:text>
		<xsl:text>TARGET_DATA_CLASS;</xsl:text>
		<xsl:text>TARGET_DATA_ORDER;</xsl:text>
		<xsl:text>TARGET_DATA_FAMILY;</xsl:text>
		<xsl:text>TARGET_DATA_GENUS;</xsl:text>
		<xsl:text>TARGET_DATA_SPECIES;</xsl:text>
		<xsl:text>TARGET_DATA_VERNACULAR_NAMES</xsl:text>
		<xsl:value-of select="$newline"/>
		<xsl:apply-templates select="//MatchingDetails/Matchings/Matching/Target"/> 
	</xsl:template>
	<xsl:template match="Target">
<xsl:variable name="sanitizedId">
	<xsl:call-template name="string-replace-all">
		<xsl:with-param name="text" select="../../../Source/id/text()"/>
		<xsl:with-param name="replace" select="'&quot;'"/>
		<xsl:with-param name="by" select="'&quot;&quot;'"/>
	</xsl:call-template>
</xsl:variable>

<xsl:variable name="sanitizedInput">
	<xsl:call-template name="string-replace-all">
		<xsl:with-param name="text" select="../../../Source/originalData/text()"/>
		<xsl:with-param name="replace" select="'&quot;'"/>
		<xsl:with-param name="by" select="'&quot;&quot;'"/>
	</xsl:call-template>
</xsl:variable>

<xsl:variable name="sanitizedPreparsedInput">
	<xsl:call-template name="string-replace-all">
		<xsl:with-param name="text" select="../../../Source/preparsedOriginalData/text()"/>
		<xsl:with-param name="replace" select="'&quot;'"/>
		<xsl:with-param name="by" select="'&quot;&quot;'"/>
	</xsl:call-template>
</xsl:variable>

<xsl:variable name="sanitizedParsedScientificName">
	<xsl:call-template name="string-replace-all">
		<xsl:with-param name="text" select="../../../Source/parsedScientificName/text()"/>
		<xsl:with-param name="replace" select="'&quot;'"/>
		<xsl:with-param name="by" select="'&quot;&quot;'"/>
	</xsl:call-template>
</xsl:variable>

<xsl:variable name="sanitizedPostParsedScientificName">
	<xsl:call-template name="string-replace-all">
		<xsl:with-param name="text" select="../../../Source/postParsedScientificName/text()"/>
		<xsl:with-param name="replace" select="'&quot;'"/>
		<xsl:with-param name="by" select="'&quot;&quot;'"/>
	</xsl:call-template>
</xsl:variable>

<xsl:variable name="sanitizedParsedAuthority">
	<xsl:call-template name="string-replace-all">
		<xsl:with-param name="text" select="../../../Source/parsedAuthority/text()"/>
		<xsl:with-param name="replace" select="'&quot;'"/>
		<xsl:with-param name="by" select="'&quot;&quot;'"/>
	</xsl:call-template>
</xsl:variable>

<xsl:variable name="sanitizedPostParsedAuthority">
	<xsl:call-template name="string-replace-all">
		<xsl:with-param name="text" select="../../../Source/postParsedAuthority/text()"/>
		<xsl:with-param name="replace" select="'&quot;'"/>
		<xsl:with-param name="by" select="'&quot;&quot;'"/>
	</xsl:call-template>
</xsl:variable>

<xsl:variable name="sanitizedScientificName">
	<xsl:call-template name="string-replace-all">
		<xsl:with-param name="text" select="scientificName/text()"/>
		<xsl:with-param name="replace" select="'&quot;'"/>
		<xsl:with-param name="by" select="'&quot;&quot;'"/>
	</xsl:call-template>
</xsl:variable>

<xsl:variable name="sanitizedAuthor">
	<xsl:call-template name="string-replace-all">
		<xsl:with-param name="text" select="author/text()"/>
		<xsl:with-param name="replace" select="'&quot;'"/>
		<xsl:with-param name="by" select="'&quot;&quot;'"/>
	</xsl:call-template>
</xsl:variable>

<xsl:variable name="vernacularNames">
	<xsl:apply-templates select="vernacularNames/vernacularName" />
</xsl:variable>

	<xsl:value-of select="$openQuote"/>
	<xsl:value-of select="../../../Source/dataSource/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$sanitizedId"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$sanitizedInput"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$sanitizedPreparsedInput"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$sanitizedParsedScientificName"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$sanitizedParsedAuthority"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="../../../Source/parser/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$sanitizedPostParsedScientificName"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$sanitizedPostParsedAuthority"/>
	<xsl:value-of select="$closeQuote"/>
	<xsl:value-of select="format-number(../@score, '0.0000000000000000')"/>
	<xsl:value-of select="';'"/>
	<xsl:value-of select="$openQuote"/>
	<xsl:value-of select="dataSource/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="id/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$sanitizedScientificName"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$sanitizedAuthor"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="kingdom/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="phylum/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="class/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="order/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="family/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="genus/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="species/text()"/>
	<xsl:value-of select="$closeOpenQuote"/>
	<xsl:value-of select="$vernacularNames"/>
	<xsl:value-of select="$openQuote"/>
	<xsl:value-of select="$newline"/>

	</xsl:template>
	<xsl:template match="vernacularName">
		<xsl:if test="position()!=1">
			<xsl:text>|</xsl:text>
		</xsl:if>
		<xsl:value-of select="substring(language/text(), 12)" />
		<xsl:text>:</xsl:text>
		<xsl:value-of select="name/text()" />
	</xsl:template>
	
	<xsl:template name="string-replace-all">
		<xsl:param name="text"/>
		<xsl:param name="replace"/>
		<xsl:param name="by"/>
		<xsl:choose>
			<xsl:when test="contains($text, $replace)">
				<xsl:value-of select="substring-before($text,$replace)"/>
				<xsl:value-of select="$by"/>
				<xsl:call-template name="string-replace-all">
					<xsl:with-param name="text" select="substring-after($text,$replace)"/>
					<xsl:with-param name="replace" select="$replace"/>
					<xsl:with-param name="by" select="$by"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>