var graphWindow = 100;
var maxPollingTime = 200;
var currentPollingTime = 1;

var interval = null;

var atomicThroughputs = new Array();
var throughputs = new Array();
var matchings = new Array();
var eta = new Array();
var meanLambda = new Array();

function updatePollingTime(value) {
	if(interval != null) {
		window.clearInterval(interval)
	}

	interval = setInterval( "updateData()", value * 1000 );

	displayPollingTime(value);
};

function displayPollingTime(value) {
	$("#sliderPost").empty().append(htime(value * 1000));
};

function updateData() {
	$.getJSON('/report', function(result) {
		var data = result.data;
		
		var engine = data.engine;
		var runtime = data.runtime;
		var timings = data.timings;
		var process = data.process;
		var comparisons = data.comparisons;
		var matchings = data.matchings;

		//ENGINE
		var $engine = $("#engine");

		setValue($engine, "name", engine);

		//RUNTIME
		var $runtime = $("#runtime");

		setValue($runtime, "totalMemory", runtime.totalMemory);
		setValue($runtime, "totalMemoryMBytes", Math.round(runtime.totalMemory / 1024 / 1024 * 100) / 100);
		setValue($runtime, "freeMemory", runtime.freeMemory);
		setValue($runtime, "freeMemoryMBytes", Math.round(runtime.freeMemory / 1024 / 1024 * 100) / 100);
		
		//TIMINGS		
		var $timings = $("#timings");

		setValue($timings, "start", new Date(parseInt(timings.start)).toString());
		
		if(typeof(timings.end) == 'undefined') {
			setValue($timings, "end", "-----");
		} else {
			setValue($timings, "end", new Date(parseInt(timings.end)).toString());
		}

		setValue($timings, "elapsed", time(timings.elapsed));

		var ETA = null;
		
		if(comparisons.throughput > 0) {
			ETA = Math.round((process.maximum - process.current) / comparisons.throughput);
		
			setValue($timings, "ETA", time(ETA));		
			setValue($timings, "EPT", time(ETA + timings.elapsed));
		} else {
			setValue($timings, "ETA", "Bootstrapping...");
			setValue($timings, "EPT", "Bootstrapping...");
		}
			
		//PROCESS
		var $process = $("#process");

		setValue($process, "initialDomain", process.initial);
		setValue($process, "currentProcess", process.current);
		setValue($process, "maxProcess", process.maximum);

		var isBatchEngine = typeof(data.currentBatch) != "undefined"; 
		
		if(isBatchEngine) {
			$("#currentBatch").show();
			setValue($process, "currentBatch", data.currentBatch);
		} else {
			$("#currentBatch").hide();
		}
				
		//COMPARISONS
		var $comparisons = $("#comparisons");

		setValue($comparisons, "currentComparisons", comparisons.current);
		setValue($comparisons, "maxComparisons", comparisons.maximum);
		setValue($comparisons, "atomicThroughput", comparisons.atomicThroughput * 1000);
		setValue($comparisons, "throughput", comparisons.throughput * 1000);
		
		//MATCHINGS
		var $matchings = $("#matchings");

		setValue($matchings, "authoritativeFull", matchings.authoritativeFullMatches);
		setValue($matchings, "authoritativeNo", matchings.authoritativeNoMatches);
		setValue($matchings, "matches", matchings.matches);
		setValue($matchings, "properMatches", matchings.properMatches);
		setValue($matchings, "meanLambda", matchings.meanLambda);
		
		if(isBatchEngine) {		
			$("#showGlobalResultMap").show();			
		} else {
			$("#showGlobalResultMap").hide();
		}
		
		addThroughputs(comparisons.atomicThroughput * 1000, 
					   comparisons.throughput * 1000, 
					   matchings.matches,
					   ETA == null ? 0 : ETA / 1000.0 / 60.0 / 60.0,
					   matchings.meanLambda);		
	});
};

function addThroughputs(atomic, normal, matches, estimate, lambda) {
	atomicThroughputs.push(atomic);
	throughputs.push(normal);
	matchings.push(matches);
	eta.push(estimate);
	meanLambda.push(lambda);
	
	if(atomicThroughputs.length > graphWindow) {
		atomicThroughputs.splice(0, 1);
	}

	if(throughputs.length > graphWindow) {
		throughputs.splice(0, 1);
	}
	
	if(matchings.length > graphWindow) {
		matchings.splice(0, 1);
	}
	
	if(eta.length > graphWindow) {
		eta.splice(0, 1);
	}
	
	if(meanLambda.length > graphWindow) {
		meanLambda.splice(0, 1);
	}

	var at = new Array();
	
	for(var i=0; i<atomicThroughputs.length; i++) 
		at.push([ i, atomicThroughputs[i] ]);

	var t = new Array();

	for(var i=0; i<throughputs.length; i++) 
		t.push([ i, throughputs[i] ]);
	
	var m = new Array();
	
	for(var i=0; i<matchings.length; i++)
		m.push([ i, matchings[i] ]);
	
	var e = new Array();
	
	for(var i=0; i<eta.length; i++)
		e.push([ i, eta[i] ]);
	
	var l = new Array();
	
	for(var i=0; i<meanLambda.length; i++)
		l.push([ i, meanLambda[i] ]);
	
	$("#plot").empty();

	var xticks = new Array();

	for(var i=0; i<=graphWindow; i=i+10)
		xticks.push([i, i]);
	
	$.jqplot('plot', 
			 [ at, t, m, e, l ], 
			 { legend:{location: 'nw', show: true}, 
			   series:[						   
		        	{label:'Atomic throughput (comparisons / sec)', showMarker: false, yaxis: 'y2axis'},
		        	{label:'Throughput (comparisons / sec)', showMarker: false, yaxis: 'y3axis'},
		        	{label:'Matches', showMarker: false},
		        	{label:'ETA (h)', showMarker: false, yaxis: 'y4axis'},
		        	{label:'Mean Lambda', showMarker: false, yaxis: 'y5axis'},
		       ],
		       axesDefaults:{useSeriesColor: true},
		       axes:{
			       	 xaxis: {ticks: xticks},
			         y2axis:{},
			         y3axis:{},
			         y4axis:{},
			         y5axis:{min: 0, max: 1}
			   }
		 	 });	
}

function setValue(category, attribute, value) {
	$("#" + attribute + " .value", category).text(value);
};

function two(x) {
	return ( x>9 ? "" : "0" ) + x;
};

function three(x) {
	return ( x>99 ? "" : "0" ) + ( x>9 ? "" : "0" ) + x;
};

function time(ms) {
	var sec = Math.floor(ms/1000);
	ms = ms % 1000;
	var t = three(ms) + "ms";

	var min = Math.floor(sec/60);
	sec = sec % 60;
	t = two(sec) + "s :" + t;

	var hr = Math.floor(min/60);
	min = min % 60;
	t = two(min) + "m :" + t;

	var day = Math.floor(hr/24);
	hr = hr % 24;
	t = two(hr) + "h :" + t;
	t = day + "d :" + t;

	return t;
}

function htime(ms) {
	var sec = Math.floor(ms/1000);
	ms = ms % 1000;

	var min = Math.floor(sec/60);
	sec = sec % 60;
	var t = two(sec) + "s";

	var hr = Math.floor(min/60);
	min = min % 60;
	t = two(min) + "m :" + t;

	var day = Math.floor(hr/24);
	hr = hr % 24;
	t = three(hr + day * 24) + "h :" + t;
	
	return t;
}

$(document).ready(function() {
	updateData();

	var slider = $("#slider").slider({
		value:10,
		min: 1,
		max: 3600,
		step: 1,
		range: "min",
		change: function(event, ui) { updatePollingTime(ui.value); },
		slide: function(event, ui) { displayPollingTime(ui.value); }
	});

	slider.slider("value", 1);
	
	$("legend").click(function() {
		$(".fieldsetContainer:first", $(this).parent()).toggle(0);		
	});
	
	$("legend").attr("title", "Click to toggle");
	$(".report fieldset").attr("title", "Click and drag to move this panel");
	
	$(".report").sortable();
	$(".report fieldset").disableSelection();
});