package org.gcube.rest.commons.helpers;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathEvaluator {
	private Node node;
	private XPath xpath;

	public XPathEvaluator(Node node) {
		this.node = node;
		XPathFactory factory = XPathFactory.newInstance();
		xpath = factory.newXPath();
	}

	public List<String> evaluate(String expression) {
		List<String> list = new ArrayList<String>(); 
		try {
			NodeList nodeList = (NodeList) xpath.evaluate(expression, node, XPathConstants.NODESET);
			for (int i = 0; i < nodeList.getLength(); i++) {
				if (nodeList.item(i).getNodeType() == 2 || nodeList.item(i).getNodeType() == 3) {
					list.add(nodeList.item(i).getTextContent());
				} else
					list.add(XMLConverter.nodeToString(nodeList.item(i)));
			}
		} catch (XPathExpressionException e) {
			try {
				Double number = (Double) xpath.evaluate(expression, node, XPathConstants.NUMBER);
				list.add(String.valueOf(number.intValue()));
			} catch (XPathExpressionException e1) {
				return null;
			}
		}
		return list;
	}

	public Node getNode() {
		return node;
	}

	public XPath getXpath() {
		return xpath;
	}
	public static void main(String[] args) {
		
		
		String xml = "<oai_dc:oai_dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n" + 
				"    xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"\n" + 
				"    xmlns:dcterms=\"http://purl.org/dc/terms/\">\n" + 
				"     <dc:title>Λάμπα τοίχου.</dc:title>\n" + 
				"     <dc:creator/>\n" + 
				"     <dc:subject>φανάρι</dc:subject>\n" + 
				"     <dc:description>Λάμπα τοίχου</dc:description>\n" + 
				"     <dc:publisher>Ίδρυμα Βαρώνου Μιχαήλ Τοσίτσα</dc:publisher>\n" + 
				"     <dc:contributor/>\n" + 
				"     <dc:date>2014-04-23</dc:date>\n" + 
				"     <dc:type>Αντικείμενο φωτισμού</dc:type>\n" + 
				"     <dc:format/>\n" + 
				"     <dc:identifier>ΓΕ_1297</dc:identifier>\n" + 
				"     <dc:source/>\n" + 
				"     <dc:language/>\n" + 
				"     <dc:coverage/>\n" + 
				"     <dc:relation/>\n" + 
				"     <dc:rights/>\n" + 
				"     <dcterms:medium>χαλκός, γυαλί</dcterms:medium>\n" + 
				"     <dc:identifier>http://gator3239.hostgator.com/~post/tositsa/PHOTO%202/GE_1297.tif</dc:identifier>\n" + 
				"     <dc:type>image/tif</dc:type>\n" + 
				"</oai_dc:oai_dc>";
		List<String> list = new XPathEvaluator(XMLConverter.stringToNode(xml)).evaluate("//*[local-name()='oai_dc']");
		
		System.out.println(list);
	}
}
