/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.helpers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONConverter {
    private static final Logger logger = LoggerFactory.getLogger(JSONConverter.class);
    private static Gson gson = new GsonBuilder().create();
    private static Gson prettygson = new GsonBuilder().setPrettyPrinting().create();

    public static String convertToJSON(Object obj) {
        return JSONConverter.convertToJSON(obj, false);
    }

    public static String convertToJSON(Object obj, boolean prettyPrint) {
        String json = prettyPrint ? prettygson.toJson(obj) : gson.toJson(obj);
        logger.trace("converted : " + obj + " json : " + json);
        return json;
    }

    public static <T> T fromJSON(String json, Class<T> clazz) {
        return (T)gson.fromJson(json, clazz);
    }

    public static String convertToJSON(String key, Object value) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(key, value);
        return JSONConverter.convertToJSON(m);
    }
}

