/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.db.dao.app;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.gcube.rest.commons.db.model.app.HostNodeModel;
import org.gcube.rest.commons.db.model.core.GenericDaoImpl;
import org.gcube.rest.commons.db.model.core.IGenericDAO;
import org.gcube.rest.commons.resourceawareservice.resources.HostNode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HostNodeModelDao
extends GenericDaoImpl<HostNodeModel>
implements IGenericDAO<HostNodeModel> {
    private static final Logger logger = LoggerFactory.getLogger(HostNodeModelDao.class);
    private static final String SCOPES_FIELD_NAME = "scopes";
    private static final String SCOPES_ALIAS = "s";
    private static final Map<String, String> aliases = ImmutableMap.of((Object)"scopes", (Object)"s");
    public static final Function<HostNodeModel, HostNode> converterModelToBase = new Function<HostNodeModel, HostNode>(){

        public HostNode apply(HostNodeModel input) {
            return input.copyTo();
        }
    };
    public static final Function<HostNode, HostNodeModel> converterBaseToModel = new Function<HostNode, HostNodeModel>(){

        public HostNodeModel apply(HostNode input) {
            return new HostNodeModel(input);
        }
    };

    @Override
    public Class<HostNodeModel> getClazz() {
        return HostNodeModel.class;
    }

    public List<HostNodeModel> getByScope(String scope) {
        SimpleExpression criterion = Restrictions.eq((String)"s.elements", (Object)scope);
        List<HostNodeModel> results = this.findByCriteria(aliases, new Criterion[]{criterion});
        return results;
    }

    public static List<HostNode> convertToHostNodeList(List<HostNodeModel> list) {
        return Lists.newArrayList((Iterable)Collections2.transform(list, converterModelToBase));
    }
}

