/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.security.Owner;
import org.gcube.common.security.secrets.AccessTokenSecret;
import org.gcube.common.security.secrets.Secret;

public class JWTSecret
extends Secret {
    public static final long TOLERANCE = TimeUnit.MILLISECONDS.toMillis(200L);
    private String jwtToken;
    private String context;
    private AccessTokenSecret accessTokenSecret;
    protected boolean initialised = false;

    public JWTSecret(String jwtToken) {
        this.jwtToken = jwtToken;
        this.init();
    }

    private synchronized void init() {
        try {
            KeycloakClient client = KeycloakClientFactory.newInstance();
            TokenResponse tokenResponse = client.queryUMAToken(this.context, "Bearer " + this.jwtToken, this.context, null);
            this.accessTokenSecret = new AccessTokenSecret(tokenResponse.getAccessToken());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void refreshAccessToken() {
        try {
            KeycloakClient client = KeycloakClientFactory.newInstance();
            TokenResponse tokenResponse = client.queryUMAToken(this.context, "Bearer " + this.jwtToken, this.context, null);
            this.accessTokenSecret = new AccessTokenSecret(tokenResponse.getAccessToken());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Owner getOwner() {
        return this.accessTokenSecret.getOwner();
    }

    public String getContext() {
        if (this.accessTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.accessTokenSecret.getContext();
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        if (this.accessTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.accessTokenSecret.getHTTPAuthorizationHeaders();
    }

    public boolean isExpired() {
        return false;
    }
}

