/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.Map;
import org.gcube.common.iam.D4ScienceIAMClient;
import org.gcube.common.iam.D4ScienceIAMClientAuthn;
import org.gcube.common.iam.D4ScienceIAMClientAuthz;
import org.gcube.common.iam.D4ScienceIAMClientException;
import org.gcube.common.security.Owner;
import org.gcube.common.security.secrets.Secret;
import org.gcube.common.security.secrets.UmaTokenSecret;

public class CredentialSecret
extends Secret {
    protected boolean initialised = false;
    private String username;
    private String password;
    private String context;
    private UmaTokenSecret accessTokenSecret;

    public CredentialSecret(String username, String password, String context) {
        this.username = username;
        this.password = password;
        this.context = context;
        this.init();
    }

    private void init() {
        this.refreshAccessToken();
    }

    private void refreshAccessToken() {
        try {
            D4ScienceIAMClient client = D4ScienceIAMClient.newInstance((String)this.context);
            D4ScienceIAMClientAuthn authn = client.authenticateUser(this.username, this.password, this.context);
            D4ScienceIAMClientAuthz authz = authn.authorize(this.context, null);
            this.accessTokenSecret = new UmaTokenSecret(authz.getAccessTokenString());
        }
        catch (D4ScienceIAMClientException e) {
            throw new RuntimeException(e);
        }
    }

    public int priority() {
        return this.accessTokenSecret.priority();
    }

    public Owner getOwner() {
        return this.accessTokenSecret.getOwner();
    }

    public String getContext() {
        if (this.isExpired()) {
            this.refreshAccessToken();
        }
        return this.accessTokenSecret.getContext();
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        if (this.accessTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.accessTokenSecret.getHTTPAuthorizationHeaders();
    }

    public boolean isExpired() {
        return this.accessTokenSecret.isExpired();
    }

    public boolean isValid() {
        return this.accessTokenSecret.isValid();
    }
}

