package org.gcube.common.software.export;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.gcube.common.software.export.biblatex.BibLaTeXSoftwareVersionExporter;
import org.gcube.common.software.export.zenodo.ZenodoSoftwareVersionExporter;
import org.gcube.common.software.model.ExporterConfig;
import org.gcube.common.software.model.GlobalConfig;
import org.gcube.common.software.model.SoftwareVersionConfig;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public abstract class SoftwareVersionExporter {

	protected static Map<String, Class<? extends SoftwareVersionExporter>> availableExporters;
	
	static {
		availableExporters = new HashMap<>();
		add(ZenodoSoftwareVersionExporter.class);
		add(BibLaTeXSoftwareVersionExporter.class);
	}
	
	private static void add(Class<? extends SoftwareVersionExporter> clz) {
		availableExporters.put(clz.getSimpleName(), clz);
	}
	
	public static Map<String, Class<? extends SoftwareVersionExporter>> getAvailableExporters() {
		return availableExporters;
	}
	
	protected File outputDirectory;
	protected GlobalConfig globalConfig;
	protected SoftwareVersionConfig softwareVersionConfig;
	protected ExporterConfig exporterConfig;
	
	protected boolean first;
	protected boolean last;
	
	protected final String exportFileNameExtension; 
	
	protected SoftwareVersionExporter(String exportFileNameExtension) {
		this.exportFileNameExtension = exportFileNameExtension;
	}
	
	public void setOutputDirectory(File outputDirectory) {
		this.outputDirectory = outputDirectory;
	}

	public GlobalConfig getGlobalConfig() {
		return globalConfig;
	}

	public void setGlobalConfig(GlobalConfig globalConfig) {
		this.globalConfig = globalConfig;
	}

	public SoftwareVersionConfig getSoftwareVersionConfig() {
		return softwareVersionConfig;
	}

	public void setSoftwareVersionConfig(SoftwareVersionConfig softwareVersionConfig) {
		this.softwareVersionConfig = softwareVersionConfig;
	}
	
	public ExporterConfig getExporterConfig() {
		return exporterConfig;
	}
	
	public void setExporterConfig(ExporterConfig processorConfig) {
		this.exporterConfig = processorConfig;
	}

	public void setFirst(boolean first) {
		this.first = first;
	}
	
	public void setLast(boolean last) {
		this.last = last;
	}

	public abstract void export() throws Exception;
	
	public File getOutputFile() throws Exception {
		String fileName = globalConfig.getFileName()+exportFileNameExtension;
		File file = new File(outputDirectory, fileName);
		return file;
	}
	
}
