package org.gcube.common.storagehub.client.dsl;

import java.io.InputStream;
import java.util.List;

import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;

public class FolderContainer extends ItemContainer<FolderItem>{
	
	private FolderItem item = null;
	
//	private String folderPath = null;
	
	protected FolderContainer(ItemManagerClient itemclient, FolderItem item) {
		super(itemclient, item);		
	}
	
	protected FolderContainer(ItemManagerClient itemclient, String folderId) {
		super(itemclient, folderId);		
	}

	
	public FolderItem get() throws Exception {
		if (item==null) return (FolderItem)itemclient.get(itemId);
		else return item;
	}
	
	public List<? extends Item>  list() {
		return itemclient.getChildren(itemId);
	}
	
	//TODO: change the return to file container
	public String uploadFile(InputStream stream, String filename, String description) {
		return itemclient.uploadFile(stream, this.itemId , filename, description);
	}
	
}
