/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.dsl;

import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;

public abstract class ItemContainer<I extends Item> {
    protected ItemManagerClient itemclient;
    protected String itemId = null;
    protected I item;

    protected ItemContainer(ItemManagerClient itemclient, I item) {
        this.itemclient = itemclient;
        this.itemId = item.getId();
    }

    protected ItemContainer(ItemManagerClient itemclient, String itemId) {
        this.itemclient = itemclient;
        this.itemId = itemId;
    }

    protected void setItem(I item) {
        this.item = item;
        this.itemId = item.getId();
    }

    public abstract ContainerType getType();

    public I get() throws Exception {
        if (this.item == null) {
            return (I)this.itemclient.get(this.itemId, new String[0]);
        }
        return this.item;
    }

    public StreamDescriptor download(String ... nodeIdsToExclude) {
        return this.itemclient.download(this.itemId, nodeIdsToExclude);
    }

    public ListResolver getAnchestors() {
        return new ListResolver(excludes -> this.itemclient.getAnchestors(this.itemId, excludes), this.itemclient);
    }

    public void delete() {
        this.itemclient.delete(this.itemId);
    }

    public FolderContainer getRootSharedFolder() {
        return new FolderContainer(this.itemclient, (FolderItem)this.itemclient.getRootSharedFolder(this.itemId));
    }
}

