package org.gcube.common.storagehub.client.dsl;

import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.common.storagehub.client.proxies.ItemManagerClient;
import org.gcube.common.storagehub.client.proxies.UserManagerClient;
import org.gcube.common.storagehub.client.proxies.WorkspaceManagerClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.Item;

public class StorageHubClient {

	private WorkspaceManagerClient wsClient = AbstractPlugin.workspace().build();
	private ItemManagerClient itemclient = AbstractPlugin.item().build();
	private GroupManagerClient groupClient = AbstractPlugin.groups().build();
	private UserManagerClient userClient = AbstractPlugin.users().build();
		
	public FolderContainer getWSRoot(){
		return new FolderContainer(itemclient, wsClient.getWorkspace());
	}
	
/*	public OpenResolver open(Path relativePath) {
		Item item = wsClient.retieveItemByPath(relativePath.toPath());
		return new OpenResolver(item, itemclient);		
	}*/
	
	public OpenResolver open(String id) throws StorageHubException{
		Item item = itemclient.get(id);
		return new OpenResolver(item, itemclient);	
	}
	
	public FolderContainer openVREFolder() {
		return new FolderContainer(itemclient, wsClient.getVreFolder());
	}
			
	public ListResolver getVREFolders() {
		return new ListResolver((onlyType, includeHidden, excludes) -> wsClient.getVreFolders(excludes), itemclient);
	}
	
	public VREFolderManager getVreFolderManager(String vreTitle) {
		return new VREFolderManager(wsClient, groupClient, vreTitle);
	}
	
	public VREFolderManager getVreFolderManager() {
		return new VREFolderManager(wsClient, groupClient, null);
	}
	
	public FolderContainer openTrash() {
		return new FolderContainer(itemclient, wsClient.getTrashFolder());
	}
	
	public void emptyTrash() {
		wsClient.emptyTrash();
	}
	
	public long getTotalVolume() {
		return wsClient.getTotalVolume();
	}
	
	public long getTotalItemCount() {
		return wsClient.getTotalItemCount();
	}
			
	public GenericItemContainer restoreThrashItem(String itemId) {
		return new GenericItemContainer(itemclient, wsClient.restoreFromTrash(itemId));
	}
	
	public void createUserAccount(String userId) throws StorageHubException {
		userClient.createUser(userId);
	}
	
	public void deleteUserAccount(String userId) throws StorageHubException {
		userClient.removeUser(userId);
	}
}
