/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bitlet.wetorrent.bencode.Bencode;
import org.bitlet.wetorrent.bencode.DictionaryComparator;
import org.bitlet.wetorrent.util.Utils;

public class Metafile
extends Bencode {
    SortedMap rootDictionary;
    private SortedMap info;
    private String announce;
    private List announceList;
    private Long creationDate;
    private String comment;
    private String createdBy;
    private long pieceLength;
    private Long length = 0L;
    private List piecesSha = new LinkedList();
    private List files = new LinkedList();
    private String name;
    private byte[] infoSha1;
    private String infoSha1Encoded;

    static String getFilename(Map<ByteBuffer, Object> file) {
        boolean first = true;
        List path = (List)file.get(ByteBuffer.wrap("path".getBytes()));
        StringBuffer pathName = new StringBuffer();
        Iterator pathIterator = path.iterator();
        while (pathIterator.hasNext()) {
            byte[] pathElem = ((ByteBuffer)pathIterator.next()).array();
            if (!first) {
                pathName.append("/");
            }
            first = false;
            pathName.append(new String(pathElem));
        }
        System.out.println("pathName : " + pathName.toString());
        return pathName.toString();
    }

    public Metafile(InputStream is) throws Exception {
        super(is);
        ByteBuffer createdByByteBuffer;
        byte[] announceByteString;
        Object sha1;
        this.rootDictionary = (SortedMap)this.getRootElement();
        this.info = (SortedMap)this.rootDictionary.get(ByteBuffer.wrap("info".getBytes()));
        this.pieceLength = (Long)this.info.get(ByteBuffer.wrap("piece length".getBytes()));
        byte[] piecesByteString = ((ByteBuffer)this.info.get(ByteBuffer.wrap("pieces".getBytes()))).array();
        for (int i = 0; i < piecesByteString.length; i += 20) {
            sha1 = new byte[20];
            System.arraycopy(piecesByteString, i, sha1, 0, 20);
            this.piecesSha.add(sha1);
        }
        this.name = new String(((ByteBuffer)this.info.get(ByteBuffer.wrap("name".getBytes()))).array());
        this.length = (Long)this.info.get(ByteBuffer.wrap("length".getBytes()));
        List files = (List)this.info.get(ByteBuffer.wrap("files".getBytes()));
        if (files != null) {
            this.length = 0L;
            sha1 = files.iterator();
            while (sha1.hasNext()) {
                Object fileObj = sha1.next();
                Map file = (Map)fileObj;
                this.files.add(file);
                this.length = this.length + (Long)file.get(ByteBuffer.wrap("length".getBytes()));
            }
        }
        if ((announceByteString = ((ByteBuffer)this.rootDictionary.get(ByteBuffer.wrap("announce".getBytes()))).array()) != null) {
            this.announce = new String(announceByteString);
        }
        this.announceList = (List)this.rootDictionary.get(ByteBuffer.wrap("announce-list".getBytes()));
        this.creationDate = (Long)this.rootDictionary.get(ByteBuffer.wrap("creation date".getBytes()));
        ByteBuffer commentByteBuffer = (ByteBuffer)this.rootDictionary.get(ByteBuffer.wrap("comment".getBytes()));
        if (commentByteBuffer != null) {
            this.comment = new String(commentByteBuffer.array());
        }
        if ((createdByByteBuffer = (ByteBuffer)this.rootDictionary.get(ByteBuffer.wrap("created by".getBytes()))) != null) {
            this.createdBy = new String(createdByByteBuffer.array());
        }
        this.computeInfoSha1();
    }

    public Metafile() {
        this.rootDictionary = new TreeMap(new DictionaryComparator());
        this.setRootElement(this.rootDictionary);
        this.info = new TreeMap(new DictionaryComparator());
        this.rootDictionary.put(ByteBuffer.wrap("info".getBytes()), this.getInfo());
        this.announceList = new LinkedList();
    }

    public SortedMap getInfo() {
        return this.info;
    }

    public void setInfo(SortedMap info) {
        this.info = info;
    }

    public String getAnnounce() {
        return this.announce;
    }

    public void setAnnounce(String announce) {
        this.announce = announce;
    }

    public List getAnnounceList() {
        return this.announceList;
    }

    public void setAnnounceList(List announceList) {
        this.announceList = announceList;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Long getPieceLength() {
        return this.pieceLength;
    }

    public void setPieceLength(Long pieceLength) {
        this.pieceLength = pieceLength;
    }

    public List getPieces() {
        return this.piecesSha;
    }

    public void setPieces(List pieces) {
        this.piecesSha = pieces;
    }

    public void computeInfoSha1() throws NoSuchAlgorithmException, IOException {
        Bencode bencode = new Bencode();
        bencode.setRootElement(this.info);
        MessageDigest md = MessageDigest.getInstance("SHA1");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bencode.print(out);
        md.update(ByteBuffer.wrap(out.toByteArray()));
        this.infoSha1 = md.digest();
    }

    public byte[] getInfoSha1() {
        return this.infoSha1;
    }

    public String getInfoSha1Encoded() {
        if (this.infoSha1Encoded == null) {
            this.infoSha1Encoded = Utils.byteArrayToURLString(this.getInfoSha1());
        }
        return this.infoSha1Encoded;
    }

    public long getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getFiles() {
        return this.files;
    }

    public boolean isSingleFile() {
        return this.getFiles().size() == 0;
    }
}

