/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.disk;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.bitlet.wetorrent.disk.FilePieceMapper;
import org.bitlet.wetorrent.util.Utils;

public class Piece {
    private byte[] sha1;
    private int length;
    private List<FilePieceMapper> files = new ArrayList<FilePieceMapper>();
    private Set<PieceBlock> blocks = new TreeSet<PieceBlock>(new Comparator<PieceBlock>(){

        @Override
        public int compare(PieceBlock o1, PieceBlock o2) {
            int beginDiff = o1.begin - o2.begin;
            if (beginDiff != 0) {
                return beginDiff;
            }
            return o1.length - o2.length;
        }
    });

    public Piece(byte[] sha1) {
        this.sha1 = sha1;
    }

    public void addFilePointer(FilePieceMapper filePointer) {
        this.files.add(filePointer);
    }

    public int getCompleted() {
        Integer completed = 0;
        for (PieceBlock block : this.blocks) {
            completed = completed + block.length;
        }
        return completed;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isCompleted() {
        return this.getCompleted() == this.length;
    }

    public void write(int begin, byte[] block) throws IOException {
        int filePieceIndex = this.findFilePieceIndex(begin);
        FilePieceMapper filePiece = this.files.get(filePieceIndex);
        int writtenBytes = 0;
        while (writtenBytes < block.length) {
            RandomAccessFile raf = filePiece.getFile();
            Long seek = filePiece.getFileOffset() + ((long)(begin + writtenBytes) - filePiece.getPieceOffset());
            raf.seek(seek);
            int byteToWrite = block.length - writtenBytes;
            Long byteAvaiableInThisFile = raf.length() - seek;
            Long byteAvaiableToWrite = (long)byteToWrite < byteAvaiableInThisFile ? (long)byteToWrite : byteAvaiableInThisFile;
            raf.write(block, writtenBytes, byteAvaiableToWrite.intValue());
            if (!byteAvaiableToWrite.equals(byteAvaiableInThisFile) || (writtenBytes += byteAvaiableToWrite.intValue()) >= block.length) continue;
            filePiece = this.files.get(++filePieceIndex);
        }
        this.addPieceBlock(begin, block.length);
        if (this.isCompleted() && !this.checkSha1()) {
            this.blocks.clear();
            throw new IOException("sha check failed");
        }
    }

    public byte[] read(int begin, int length) throws IOException {
        if (!this.isAvaiable(begin, length)) {
            throw new EOFException("Data not available begin: " + begin + " length: " + length);
        }
        int filePieceIndex = this.findFilePieceIndex(begin);
        FilePieceMapper filePiece = this.files.get(filePieceIndex);
        byte[] block = new byte[length];
        int readBytes = 0;
        while (readBytes < length) {
            RandomAccessFile raf = filePiece.getFile();
            Long seek = filePiece.getFileOffset() + ((long)(begin + readBytes) - filePiece.getPieceOffset());
            raf.seek(seek);
            int byteToRead = length - readBytes;
            Long byteAvaiableInThisFile = raf.length() - seek;
            Long byteAvaiableToRead = (long)byteToRead < byteAvaiableInThisFile ? (long)byteToRead : byteAvaiableInThisFile;
            raf.readFully(block, readBytes, byteAvaiableToRead.intValue());
            if (!byteAvaiableToRead.equals(byteAvaiableInThisFile) || (readBytes += byteAvaiableToRead.intValue()) >= length) continue;
            filePiece = this.files.get(++filePieceIndex);
        }
        return block;
    }

    private int findFilePieceIndex(int begin) {
        int i = 0;
        for (i = 0; i < this.files.size() - 1; ++i) {
            if (this.files.get(i).getPieceOffset() > (long)begin || this.files.get(i + 1).getPieceOffset() <= (long)begin) continue;
            return i;
        }
        return i;
    }

    public void addPieceBlock(int begin, int length) {
        PieceBlock newPieceBlock = new PieceBlock(begin, length);
        this.blocks.add(newPieceBlock);
        Iterator<PieceBlock> iterator = this.blocks.iterator();
        PieceBlock prev = iterator.next();
        LinkedList<PieceBlock> blocksToBeRemoved = new LinkedList<PieceBlock>();
        while (iterator.hasNext()) {
            PieceBlock p = iterator.next();
            if (prev.begin + prev.length >= p.begin) {
                p.length = Math.max(p.length + (p.begin - prev.begin), prev.length);
                p.begin = prev.begin;
                blocksToBeRemoved.add(prev);
            }
            prev = p;
        }
        for (PieceBlock pb : blocksToBeRemoved) {
            this.blocks.remove(pb);
        }
    }

    public boolean isAvaiable(int begin, int length) {
        for (PieceBlock block : this.blocks) {
            if (begin >= block.begin && length <= block.length) {
                return true;
            }
            if (begin + length >= block.begin) continue;
            return false;
        }
        return false;
    }

    public int getFirstMissingByte() {
        if (this.blocks.size() > 0) {
            PieceBlock firstBlock = this.blocks.iterator().next();
            if (firstBlock.begin == 0) {
                return firstBlock.length;
            }
            return 0;
        }
        return 0;
    }

    public boolean checkSha1() throws IOException {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        byte[] pieceBuffer = this.read(0, this.length);
        byte[] sha1Digest = md.digest(pieceBuffer);
        return Utils.bytesCompare(this.sha1, sha1Digest);
    }

    public void clear() {
        this.blocks.clear();
    }

    public int available(int begin) {
        for (PieceBlock pb : this.blocks) {
            if (pb.begin > begin || pb.begin + pb.length <= begin) continue;
            return pb.begin + pb.length - begin;
        }
        return 0;
    }

    private static class PieceBlock {
        public Integer begin;
        public Integer length;

        public PieceBlock(Integer begin, Integer lenght) {
            this.begin = begin;
            this.length = lenght;
        }

        public String toString() {
            return "b:" + this.begin + " l:" + this.length;
        }
    }
}

