/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.pieceChooser;

import java.util.Random;
import org.bitlet.wetorrent.Torrent;
import org.bitlet.wetorrent.peer.Peer;
import org.bitlet.wetorrent.pieceChooser.PieceChooser;

public class RouletteWheelPieceChooser
extends PieceChooser {
    Random rand = new Random(System.currentTimeMillis());

    @Override
    protected Integer choosePiece(Peer peer, int[] piecesFrequencies) {
        int i;
        int[] probabilities = (int[])piecesFrequencies.clone();
        int maxFrequency = 0;
        Torrent torrent = this.getTorrent();
        for (int i2 = 0; i2 < torrent.getMetafile().getPieces().size(); ++i2) {
            if (peer.hasPiece(i2) && !torrent.getTorrentDisk().isCompleted(i2) && !this.isCompletingPiece(i2)) {
                if (maxFrequency >= probabilities[i2]) continue;
                maxFrequency = probabilities[i2];
                continue;
            }
            probabilities[i2] = Integer.MAX_VALUE;
        }
        int total = 0;
        for (int i3 = 0; i3 < torrent.getMetafile().getPieces().size(); ++i3) {
            probabilities[i3] = probabilities[i3] == Integer.MAX_VALUE ? 0 : 1 + maxFrequency - probabilities[i3];
            probabilities[i3] = total += probabilities[i3];
        }
        if (total == 0) {
            return null;
        }
        long random = this.rand.nextInt(total);
        if (random < (long)probabilities[0]) {
            return 0;
        }
        for (i = 1; i < probabilities.length && ((long)probabilities[i - 1] > random || (long)probabilities[i] <= random); ++i) {
        }
        return i;
    }
}

