/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.wetorrent.util;

import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class Utils {
    public static String byteArrayToURLString(byte[] in) {
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        while (i < in.length) {
            if (in[i] >= 48 && in[i] <= 57 || in[i] >= 97 && in[i] <= 122 || in[i] >= 65 && in[i] <= 90 || in[i] == 45 || in[i] == 95 || in[i] == 46 || in[i] == 126) {
                out.append((char)in[i]);
                ++i;
                continue;
            }
            out.append('%');
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            ++i;
        }
        String rslt = new String(out);
        return rslt;
    }

    public static String byteArrayToByteString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public static boolean bytesCompare(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    public static String escapeJavascriptString(String string) {
        if (string == null) {
            return null;
        }
        StringWriter writer = new StringWriter(string.length() * 2);
        int sz = string.length();
        block12: for (int i = 0; i < sz; ++i) {
            char ch = string.charAt(i);
            if (ch > '\u0fff') {
                writer.write("\\u" + Utils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                writer.write("\\u0" + Utils.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                writer.write("\\u00" + Utils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        writer.write(92);
                        writer.write(98);
                        break;
                    }
                    case '\n': {
                        writer.write(92);
                        writer.write(110);
                        break;
                    }
                    case '\t': {
                        writer.write(92);
                        writer.write(116);
                        break;
                    }
                    case '\f': {
                        writer.write(92);
                        writer.write(102);
                        break;
                    }
                    case '\r': {
                        writer.write(92);
                        writer.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            writer.write("\\u00" + Utils.hex(ch));
                            break;
                        }
                        writer.write("\\u000" + Utils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    writer.write(92);
                    writer.write(39);
                    continue block12;
                }
                case '\"': {
                    writer.write(92);
                    writer.write(34);
                    continue block12;
                }
                case '\\': {
                    writer.write(92);
                    writer.write(92);
                    continue block12;
                }
                default: {
                    writer.write(ch);
                }
            }
        }
        return writer.toString();
    }

    @Deprecated
    public static String byteToHumanReadableString(long byteNumber) {
        if (byteNumber < 1024L) {
            return byteNumber + " B";
        }
        if (byteNumber < 0x100000L) {
            Double kiloBytePerSecond = (double)byteNumber / 1024.0;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            StringBuffer sb = df.format(kiloBytePerSecond, new StringBuffer(), new FieldPosition(1));
            return sb + " KB";
        }
        if (byteNumber < 0x40000000L) {
            Double megaBytePerSecond = (double)byteNumber / 1048576.0;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            StringBuffer sb = df.format(megaBytePerSecond, new StringBuffer(), new FieldPosition(1));
            return sb + " MB";
        }
        Double gigaBytePerSecond = (double)byteNumber / 1.073741824E9;
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        StringBuffer sb = df.format(gigaBytePerSecond, new StringBuffer(), new FieldPosition(1));
        return sb + " GB";
    }
}

