/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.codelistmanager.managers;

import java.io.File;
import java.net.URI;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.TableAlreadyExistsException;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.ObjectStateControl;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTable;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.util.CodeListType;
import org.gcube.contentmanagement.codelistmanager.util.ImporterInterface;
import org.gcube.contentmanagement.codelistmanager.util.csv.CSVImport;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportLineProcessor;
import org.gcube.contentmanagement.codelistmanager.util.csv.InitializerProcessor;
import org.gcube.contentmanagement.codelistmanager.util.csv.ProgresChangedEvent;
import org.gcube.contentmanagement.codelistmanager.util.opensdmx.CLSDMXImport;
import org.gcube.contentmanagement.codelistmanager.util.opensdmx.HCLSDMXImport;
import org.gcube.contentmanagement.codelistmanager.util.opensdmx.SDMXImport;
import org.opensdmx.client.sdmx20.direct.Sdmx20CustomRegistryClient;
import org.sdmx.resources.sdmxml.schemas.v2_0.message.Structure;
import org.sdmx.resources.sdmxml.schemas.v2_0.structure.HierarchicalCodelistType;

@TableRootDefinition
public class CodeListImport
extends ObjectStateControl {
    private ProgresChangedEvent onProgressChanged = new ProgresChangedEvent(){

        @Override
        public void onProgresChanged(int value) {
            CodeListImport.this.progress = value;
            if (CodeListImport.this.progress % 30 == 0) {
                CodeListImport.this.store();
            }
        }
    };
    private static GCUBELog logger = new GCUBELog(CodeListImport.class);
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private String tableName;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String id = UUIDGenFactory.getUUIDGen().nextUUID();
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private String agencyId = "undefined";
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private String name = "undefined";
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String description = "undefined";
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private boolean isFinal = false;
    @FieldDefinition(precision={4, 2}, specifications={Specification.NOT_NULL})
    private float version = 0.0f;
    @FieldDefinition(precision={20})
    private String validFrom;
    @FieldDefinition(precision={20})
    private String validTo;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private Status status;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private Calendar lastUpdate = Calendar.getInstance();
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private int totalLines = 0;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private int progress = 0;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private CodeListType codelistType;
    @FieldDefinition
    private Hashtable<String, TableField> fieldsName;
    @FieldDefinition
    private List<ColumnDefinition> tableDefinition;

    public CodeListImport() {
        this.tableName = "rdi" + this.id.replaceAll("-", "");
        this.status = Status.Initialized;
        this.codelistType = CodeListType.Unknown;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Hashtable<String, TableField> getFieldsName() {
        return this.fieldsName;
    }

    public List<ColumnDefinition> getTableDefinition() {
        return this.tableDefinition;
    }

    public String getId() {
        return this.id;
    }

    public CodeListType getCodelistType() {
        return this.codelistType;
    }

    public void setCodelistType(CodeListType codelistType) {
        this.codelistType = codelistType;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(String agencyId) {
        this.agencyId = agencyId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Calendar getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Calendar lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    protected void setFieldsName(Hashtable<String, TableField> tableFieldMapping) {
        this.fieldsName = tableFieldMapping;
    }

    protected void setTableDefinition(List<ColumnDefinition> tableDefinition) {
        this.tableDefinition = tableDefinition;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean store() {
        try {
            ObjectPersistency op = ObjectPersistency.get(CodeListImport.class);
            if (!op.existsKey((Object)this.getId())) {
                op.insert((Object)this);
            } else {
                op.update((Object)this);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error storing on DB", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean importSDMX(URI uri) {
        try {
            Sdmx20CustomRegistryClient sdmxClient = new Sdmx20CustomRegistryClient();
            Structure structure = sdmxClient.retrieveStructure(uri.toURL());
            return this.parseSDMXStructure(structure);
        }
        catch (Exception e) {
            this.setStatus(Status.Failed);
            logger.error((Object)"import process failed", (Throwable)e);
            this.store();
            return false;
        }
    }

    public boolean importSDMX(File file) {
        try {
            Sdmx20CustomRegistryClient sdmxClient = new Sdmx20CustomRegistryClient();
            Structure structure = sdmxClient.retrieveStructure(file);
            return this.parseSDMXStructure(structure);
        }
        catch (Exception e) {
            this.setStatus(Status.Failed);
            logger.error((Object)"import process failed", (Throwable)e);
            this.store();
            return false;
        }
    }

    private boolean parseSDMXStructure(Structure structure) throws Exception {
        SDMXImport sdmxImport;
        if (structure.getCodeLists() != null) {
            sdmxImport = new CLSDMXImport((org.sdmx.resources.sdmxml.schemas.v2_0.structure.CodeListType)structure.getCodeLists().getCodeLists().get(0));
            this.codelistType = CodeListType.Simple;
        } else if (structure.getHierarchicalCodelists() != null) {
            sdmxImport = new HCLSDMXImport((HierarchicalCodelistType)structure.getHierarchicalCodelists().getHierarchicalCodelists().get(0));
            this.codelistType = CodeListType.Hierarchical;
        } else {
            logger.error((Object)"no valid file for sdmx");
            return false;
        }
        this.setAgencyId(sdmxImport.getAgencyId());
        this.setDescription(sdmxImport.getDescription());
        this.setName(sdmxImport.getName());
        this.setFinal(sdmxImport.isFinal());
        this.setVersion(sdmxImport.getVersion());
        return this.importData(sdmxImport);
    }

    public boolean importCSV(File file, String encoding, boolean hasHeader, char delimiter, boolean deleteFileWhenFinished) {
        boolean result = this.importData(new CSVImport(file, hasHeader, delimiter, encoding, new InitializerProcessor(), new ImportLineProcessor()));
        if (deleteFileWhenFinished) {
            file.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importData(ImporterInterface importerInterface) {
        SimpleTable table = null;
        DBSession session = null;
        try {
            this.setStatus(Status.InProgress);
            if (!this.store()) {
                throw new Exception("error storing import");
            }
            session = DBSession.connect();
            session.disableAutoCommit();
            importerInterface.initialize();
            try {
                table = this.createTable(importerInterface.getTableDefinition(), this.tableName, session);
            }
            catch (TableAlreadyExistsException e) {
                Utility.drop((String)this.tableName).execute(session);
                table = this.createTable(importerInterface.getTableDefinition(), this.tableName, session);
            }
            session.commit();
            this.totalLines = importerInterface.getTotalLines();
            if (!this.store()) {
                throw new Exception("error storing import");
            }
            importerInterface.process(table, this.onProgressChanged);
            this.setTableDefinition(importerInterface.getTableDefinition());
            this.setFieldsName(importerInterface.getFieldsName());
            session.commit();
            this.setStatus(Status.Complete);
            if (!this.store()) {
                throw new Exception("error storing import");
            }
        }
        catch (Exception e) {
            logger.error((Object)"import process failed", (Throwable)e);
            try {
                if (session != null) {
                    session.rollback();
                    if (table != null) {
                        Utility.drop((String)this.tableName).execute(session);
                    }
                }
                this.setStatus(Status.Failed);
                this.store();
            }
            catch (Exception e1) {
                logger.warn((Object)"clean table failed");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return true;
    }

    public boolean remove() {
        try {
            Utility.drop((String)this.getTableName());
            ObjectPersistency.get(CodeListImport.class).deleteByKey((Object)this.id);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private SimpleTable createTable(List<ColumnDefinition> tableDefintion, String tableName, DBSession session) throws Exception {
        SimpleTable toReturn = null;
        CreateTable create = (CreateTable)DBSession.getImplementation(CreateTable.class);
        create.setTableName(tableName);
        create.setColumnsDefinition(tableDefintion.toArray(new ColumnDefinition[tableDefintion.size()]));
        toReturn = create.execute(session);
        return toReturn;
    }

    public static CodeListImport get(String id) throws Exception {
        return (CodeListImport)((Object)ObjectPersistency.get(CodeListImport.class).getByKey((Object)id));
    }

    public static Iterator<CodeListImport> getAll() throws Exception {
        return ObjectPersistency.get(CodeListImport.class).getAll();
    }

    public static enum Status {
        InProgress,
        Initialized,
        Failed,
        Complete;

    }
}

