/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.contexts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.context.ServiceContext;
import org.gcube.contentmanagement.contentmanager.plugin.PluginContext;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.FactoryDelegate;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.SMSFactory;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSInterfaceImpl;
import org.gcube.contentmanagement.contentmanager.smsplugin.types.SMSDelegateType;
import org.gcube.contentmanagement.contentmanager.smsplugin.types.SMSWrapCollection;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.ConversionUtil;
import org.w3c.dom.Element;

public class SMSPluginContext
extends PluginContext {
    private static SMSFactory singleton = new SMSFactory();
    private static List<Element> payloads = new ArrayList<Element>();
    protected static GCUBELog logger = new GCUBELog(SMSPluginContext.class);
    public static final String NS = "http://gcube-system.org/namespaces/contentmanagement/contentmanager/smsplugin";

    public SMSPluginContext() throws Exception {
        logger.info((Object)"[BEGIN] initializing SMSPluginContenxt");
        logger.trace((Object)"Initializing the SMSInterface");
        ServiceContext serviceContext = ServiceContext.getContext();
        SMSPluginContext.initializeSMSInterface(serviceContext.getInstance().getScopes().values(), (GCUBESecurityManager)serviceContext);
        logger.trace((Object)"SMSInterface initialized");
        this.setPayloads();
        logger.info((Object)"[END] initialization complete");
    }

    protected void setPayloads() throws Exception {
        SMSWrapCollection smsWrapCollection = new SMSWrapCollection("CollectionId", "CollectionDescription", true, SMSDelegateType.FULL);
        payloads.add(ConversionUtil.toElement(smsWrapCollection));
    }

    public static void initializeSMSInterface(Collection<GCUBEScope> scopes, GCUBESecurityManager securityManager) throws Exception {
        GCUBEScope scope = scopes.iterator().next();
        SMSInterfaceImpl.initializeInterface(scope, securityManager);
    }

    public List<Element> getCreatePayloads() {
        return payloads;
    }

    public FactoryDelegate getFactory() {
        return singleton;
    }
}

