/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates;

import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.plugin.delegates.ReadDelegate;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.DocumentConversionUtil;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.ReadUtil;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.SMSCollection;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.exception.SMSServiceErrorException;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.CollectionIterator;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.RSInfoObjectTreeIterator;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSInterface;
import org.gcube.contentmanagement.contentmanager.stubs.calls.exceptions.UnknownDocumentException;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RSIterator;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Bindings;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Node;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableObjectNotFoundFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableValueNotValidFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.SMSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.relation.ReferenceTargetFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.SMSResponseConfig;

public class ReadManager
extends ReadDelegate {
    private static final long serialVersionUID = 6109582622523144991L;
    protected static final GCUBELog logger = new GCUBELog(ReadManager.class);

    protected SMSInterface getSmsInterface() {
        return ((SMSCollection)this.getCollection()).getSmsInterface();
    }

    public GDoc get(String id, Predicate predicate) throws Exception, GCUBEException {
        StringWriter w;
        logger.info((Object)("get id: " + id + " projection: " + predicate));
        long startTime = System.currentTimeMillis();
        DocumentProjection projection = new DocumentProjection((TreePredicate)predicate);
        logger.trace((Object)"calculating SMS response config");
        InformationObjectTreeResponse response = ReadUtil.createResponseConfig(projection);
        SMSInterface smsInterface = this.getSmsInterface();
        logger.debug((Object)("retrieving the document InfoObjectTree " + id));
        InfoObjectTree tree = null;
        try {
            tree = smsInterface.retrieveTree(id, response);
        }
        catch (GCUBEUnrecoverableObjectNotFoundFault e) {
            logger.error((Object)"Error retrieving main document tree, document not found", (Throwable)e);
            throw new UnknownDocumentException("Document not found for id " + id, (Throwable)e);
        }
        catch (GCUBEUnrecoverableValueNotValidFault e) {
            logger.error((Object)"Error retrieving main document tree, value not valid", (Throwable)e);
            throw new GCUBEUnrecoverableException("Error retrieving main document tree, value not valid", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Error retrieving main document tree", (Throwable)e);
            throw new SMSServiceErrorException("Error retrieving main document tree", e);
        }
        String collectionId = this.getCollection().getID();
        logger.debug((Object)"converting the document to GDoc");
        GDoc doc = DocumentConversionUtil.convertToGDoc(collectionId, tree);
        logger.debug((Object)"conversion complete");
        if (logger.isTraceEnabled()) {
            w = new StringWriter();
            Bindings.toXML((GDoc)doc, (Writer)w, (boolean[])new boolean[0]);
            logger.trace((Object)("Produced gdoc: " + w.toString()));
        }
        if (projection != null) {
            logger.debug((Object)"pruning.. ");
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("projection: " + projection.toString()));
            }
            try {
                predicate.prune((Node)doc);
            }
            catch (Exception e) {
                logger.error((Object)"the document don't match");
                throw new UnknownDocumentException("The retrieved document don't match the projection", (Throwable)e);
            }
            if (logger.isTraceEnabled()) {
                w = new StringWriter();
                Bindings.toXML((GDoc)doc, (Writer)w, (boolean[])new boolean[0]);
                logger.trace((Object)("Pruned gdoc: " + w.toString()));
            }
        }
        logger.info((Object)("document returned in " + (System.currentTimeMillis() - startTime)));
        return doc;
    }

    public RemoteIterator<GDoc> get(final RSIterator<String> iterator, final Predicate projection) throws Exception, GCUBEException {
        logger.info((Object)("get with input iterator projection: " + projection));
        return new RemoteIterator<GDoc>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public GDoc next() {
                String nextId;
                try {
                    nextId = (String)iterator.next();
                }
                catch (Exception e) {
                    logger.error((Object)"Error getting next id from RS iterator", (Throwable)e);
                    return null;
                }
                logger.debug((Object)("processing id: " + nextId));
                try {
                    return ReadManager.this.get(nextId, projection);
                }
                catch (GCUBEException e) {
                    logger.error((Object)("Error getting document with id: " + nextId), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)("Error getting document with id: " + nextId), (Throwable)e);
                }
                return null;
            }

            public void close() {
                iterator.close();
            }

            public String locator() {
                return iterator.locator();
            }
        };
    }

    public RemoteIterator<GDoc> get(Predicate predicate) throws Exception, GCUBEException {
        logger.info((Object)("get projection: " + predicate));
        long startTime = System.currentTimeMillis();
        DocumentProjection projection = new DocumentProjection((TreePredicate)predicate);
        String collectionId = this.getCollection().getID();
        logger.debug((Object)("Retrieving collection from SMS (coll id: " + collectionId + ")"));
        LinkedList<SMSFilter> filters = new LinkedList<SMSFilter>();
        ReferenceTargetFilter targetFilter = new ReferenceTargetFilter("contentmanagement:is-member-of", null, collectionId);
        filters.add((SMSFilter)targetFilter);
        logger.trace((Object)"calculating SMS response config");
        InformationObjectTreeResponse responseConfig = ReadUtil.createResponseConfig(projection);
        SMSInterface smsInterface = this.getSmsInterface();
        String locator = smsInterface.retrieveFilteredIOs((SMSResponseConfig)responseConfig, filters);
        logger.debug((Object)("initializing rs reader (locator:" + locator + ")"));
        RSInfoObjectTreeIterator rsElementIterator = new RSInfoObjectTreeIterator(locator);
        CollectionIterator collectionIterator = new CollectionIterator(logger, collectionId, rsElementIterator, predicate);
        logger.info((Object)("iterator returned in " + (System.currentTimeMillis() - startTime)));
        return collectionIterator;
    }
}

