/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.importer.model.WriteUtil;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.ISUtil;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSCollectionInfo;
import org.gcube.contentmanagement.contentmanager.smsplugin.delegates.util.SMSInterface;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicInfoObjectDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicPropertyDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreateInfoObjectReferencesProperties;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.CreatePropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.FileTransferParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBERetrySameIOFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableObjectNotFoundFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GCUBEUnrecoverableValueNotValidFault;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.GetVolatileInformationParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectIDAndConsumedHints;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectTree;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.NameAndType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertySelector;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SMSPortType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SMSPortType1PortType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageHint;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.StorageManagementCall;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.VolatileInformation;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.SMSFilter;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.InformationObjectTreeResponse;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.response.SMSResponseConfig;

public class SMSInterfaceImpl
implements SMSInterface {
    protected GCUBELog logger = new GCUBELog(SMSInterfaceImpl.class);
    protected StorageManagementCall smsCall;
    protected SMSPortType1PortType smsPortType1;
    protected static SMSInterface instance;

    public static void initializeInterface(GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        instance = new SMSInterfaceImpl(scope, securityManager);
    }

    public static SMSInterface getInstance() throws Exception {
        if (instance == null) {
            throw new Exception("SMSInterface not initialized");
        }
        return instance;
    }

    protected SMSInterfaceImpl(GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        SMSPortType portType;
        this.logger.trace((Object)("Retrieving the SMSPortType in scope " + scope));
        try {
            portType = ISUtil.getStorageManagementPortType(scope, securityManager);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error retrieving the SMS port type", (Throwable)e);
            throw e;
        }
        this.smsCall = new StorageManagementCall(portType);
        this.logger.trace((Object)("Retrieving the SMSPortType1 in scope " + scope));
        try {
            this.smsPortType1 = ISUtil.getStorageManagementPortType1(scope, securityManager);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error retrieving the SMS port type 1", (Throwable)e);
            throw e;
        }
    }

    public StorageManagementCall getSmsCall() {
        return this.smsCall;
    }

    public SMSPortType1PortType getSmsPortType1() {
        return this.smsPortType1;
    }

    @Override
    public InfoObjectDescription getInfoObject(String objectID, String targetLocation, StorageHint[] hints) throws RemoteException {
        FileTransferParameters parameters = new FileTransferParameters();
        parameters.setObjectID(objectID);
        parameters.setFileLocation(targetLocation);
        parameters.setStorageHints(hints);
        return this.smsPortType1.getInfoObject(parameters);
    }

    @Override
    public boolean existsInfoObject(String oid) throws RemoteException, GCUBERetrySameIOFault {
        return this.smsPortType1.existsInfoObject(oid);
    }

    @Override
    public InfoObjectTree retrieveTree(String oid, InformationObjectTreeResponse responseConfig) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        return this.smsCall.retrieveTree(oid, responseConfig);
    }

    @Override
    public String retrieveFilteredIOs(SMSResponseConfig responseConfig, List<SMSFilter> filters) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        return this.smsCall.retrieveFilteredIOs(responseConfig, filters);
    }

    @Override
    public SMSCollectionInfo getCollectionInfo(String collectionId) throws Exception {
        this.logger.debug((Object)("getCollectionInfo collectionId: " + collectionId));
        VolatileInformation collectionIO = this.getCollectionVolatileInformation(collectionId);
        SMSCollectionInfo collectionInfo = new SMSCollectionInfo();
        this.logger.trace((Object)"Filling the collection profile with collection data");
        collectionInfo.setId(collectionIO.getObjectID());
        collectionInfo.setName(collectionIO.getName());
        if (collectionIO.getProperties() == null) {
            this.logger.fatal((Object)"The collection IO don't contains the object properties");
            throw new Exception("The collection IO don't contains the object properties");
        }
        for (PropertyDescription property : collectionIO.getProperties()) {
            String propertyName = property.getName();
            String propertyValue = property.getValue();
            if (propertyValue == null) continue;
            if ("contentmanagement:ObjectCreatedMillis".equals(propertyName)) {
                collectionInfo.setCreationTime(BasicPropertyDescription.convertLongStringToCalendar((String)propertyValue));
                continue;
            }
            if ("contentmanagement:ObjectLastModificationMillis".equals(propertyName)) {
                Calendar lastUpdate = BasicPropertyDescription.convertLongStringToCalendar((String)propertyValue);
                collectionInfo.setLastUpdate(lastUpdate);
                continue;
            }
            if (!"contentmanagement:collectiondescription".equals(propertyName)) continue;
            collectionInfo.setDescription(propertyValue);
        }
        if (collectionIO.getNumberOfReferences() != null) {
            int numberOfReferences = collectionIO.getNumberOfReferences().intValue();
            collectionInfo.setCardinality(numberOfReferences);
        }
        this.logger.trace((Object)("returning " + collectionInfo));
        return collectionInfo;
    }

    protected VolatileInformation getCollectionVolatileInformation(String collectionID) throws Exception {
        GetVolatileInformationParameters params = new GetVolatileInformationParameters();
        params.setObjectID(collectionID);
        params.setRole("contentmanagement:is-member-of");
        params.setIsSource(Boolean.FALSE);
        params.setIncludeProperties(Boolean.TRUE);
        VolatileInformation vinfo = this.smsPortType1.getVolatileInformation(params);
        if (!BasicInfoObjectDescription.isCollectionType((String)vinfo.getType())) {
            this.logger.error((Object)("Got object '" + collectionID + "' of type '" + vinfo.getType() + "' when expecting '" + "contentmanagement:collection" + "'!"));
            throw new Exception("Object with ID '" + collectionID + "' is not a valid collection.");
        }
        return vinfo;
    }

    @Override
    public String createCollection(String name, String description) throws GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        this.logger.debug((Object)("Creating new collection with name '" + name + "'"));
        NameAndType createParameters = new NameAndType();
        createParameters.setName(name);
        createParameters.setType("contentmanagement:collection");
        this.logger.trace((Object)"Calling the SMS service");
        String newCollectionID = this.smsPortType1.createInfoObject(createParameters);
        this.logger.trace((Object)("New collection id: " + newCollectionID));
        this.logger.trace((Object)"Setting flavour");
        this.setInformationObjectProperty(newCollectionID, new CreatePropertyDescription("contentmanagement:ObjectFlavour", "xsd:string", "contentmanagement:Materialized"));
        this.setInformationObjectProperty(newCollectionID, new CreatePropertyDescription("contentmanagement:collectiondescription", "xsd:string", description));
        return newCollectionID;
    }

    @Override
    public String storeInformationObject(CreateInfoObjectReferencesProperties createInfoObjectParams) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        this.logger.debug((Object)("storeInformationObject createInfoObjectParams: " + WriteUtil.toString(createInfoObjectParams)));
        InfoObjectIDAndConsumedHints reply = this.smsPortType1.createInfoObjectWithContent(createInfoObjectParams);
        return reply.getObjectID();
    }

    @Override
    public boolean deleteInformationObject(String oid) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        this.logger.debug((Object)("deleteInformationObject oid: " + oid));
        return this.smsPortType1.removeInfoObject(oid);
    }

    @Override
    public boolean deleteInformationObjectProperty(String oid, String propertyName) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        this.logger.debug((Object)("deleteInformationObjectProperty oid: " + oid + ", propertyName: " + propertyName));
        return this.smsPortType1.unsetStorageProperty(new PropertySelector(propertyName, oid));
    }

    @Override
    public void setInformationObjectProperty(String oid, CreatePropertyDescription propertyDescription) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        this.logger.debug((Object)("setInformationObjectProperty oid: " + oid + ", propertyDescription: " + WriteUtil.toString(propertyDescription)));
        this.smsPortType1.setStorageProperty(new PropertyDescription(propertyDescription.getName(), oid, propertyDescription.getType(), propertyDescription.getValue()));
    }

    @Override
    public void updateInformationObjectRawContent(String oid, String fileLocation) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        this.logger.debug((Object)("updateInformationObjectRawContent oid: " + oid + ", fileLocation: " + fileLocation));
        StorageHint[] hints = new StorageHint[]{new StorageHint("do-not-update-content-mime-type", BasicStorageHints.HINT_VALUE_TRUE)};
        this.smsPortType1.updateRawContent(new FileTransferParameters(fileLocation, oid, null, hints));
    }

    @Override
    public void updateInformationObjectRawContent(String oid, byte[] content) throws GCUBEUnrecoverableObjectNotFoundFault, GCUBERetrySameIOFault, GCUBEUnrecoverableValueNotValidFault, RemoteException {
        this.logger.debug((Object)("updateInformationObjectRawContent oid: " + oid + ", content.length: " + content.length));
        StorageHint[] hints = new StorageHint[]{new StorageHint("do-not-update-content-mime-type", BasicStorageHints.HINT_VALUE_TRUE)};
        this.smsPortType1.updateRawContent(new FileTransferParameters(null, oid, content, hints));
    }
}

