/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ChangeEvent;
import com.mongodb.ChangeListener;
import com.mongodb.ClusterableServer;
import com.mongodb.Connection;
import com.mongodb.Mongo;
import com.mongodb.PooledConnectionProvider;
import com.mongodb.ServerAddress;
import com.mongodb.ServerConnectionState;
import com.mongodb.ServerDescription;
import com.mongodb.ServerMonitor;
import com.mongodb.ServerSettings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bson.util.Assertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultServer
implements ClusterableServer {
    private final ServerAddress serverAddress;
    private final ServerMonitor serverMonitor;
    private final PooledConnectionProvider connectionProvider;
    private final Map<ChangeListener<ServerDescription>, Boolean> changeListeners = new ConcurrentHashMap<ChangeListener<ServerDescription>, Boolean>();
    private final ChangeListener<ServerDescription> serverStateListener;
    private volatile ServerDescription description;
    private volatile boolean isClosed;

    public DefaultServer(ServerAddress serverAddress, ServerSettings settings, String clusterId, PooledConnectionProvider connectionProvider, Mongo mongo) {
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
        this.description = ServerDescription.builder().state(ServerConnectionState.Connecting).address(serverAddress).build();
        this.serverStateListener = new DefaultServerStateListener();
        this.serverMonitor = new ServerMonitor(serverAddress, this.serverStateListener, settings.getHeartbeatSocketSettings(), settings, clusterId, mongo);
        this.serverMonitor.start();
        this.connectionProvider = connectionProvider;
    }

    @Override
    public ServerDescription getDescription() {
        Assertions.isTrue("open", !this.isClosed());
        return this.description;
    }

    @Override
    public Connection getConnection(long maxWaitTime, TimeUnit timeUnit) {
        return this.connectionProvider.get(maxWaitTime, timeUnit);
    }

    @Override
    public void addChangeListener(ChangeListener<ServerDescription> changeListener) {
        Assertions.isTrue("open", !this.isClosed());
        this.changeListeners.put(changeListener, true);
    }

    @Override
    public void invalidate() {
        Assertions.isTrue("open", !this.isClosed());
        this.serverStateListener.stateChanged(new ChangeEvent<ServerDescription>(this.description, ServerDescription.builder().state(ServerConnectionState.Connecting).address(this.serverAddress).build()));
        this.connectionProvider.invalidate();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.serverMonitor.close();
            this.connectionProvider.close();
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void connect() {
        this.serverMonitor.connect();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultServerStateListener
    implements ChangeListener<ServerDescription> {
        private DefaultServerStateListener() {
        }

        @Override
        public void stateChanged(ChangeEvent<ServerDescription> event) {
            DefaultServer.this.description = event.getNewValue();
            for (ChangeListener listener : DefaultServer.this.changeListeners.keySet()) {
                listener.stateChanged(event);
            }
        }
    }
}

