/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.springframework.beans.factory.InitializingBean;

public abstract class DestinationMapEntry
implements InitializingBean,
Comparable {
    private ActiveMQDestination destination;

    public int compareTo(Object that) {
        if (that instanceof DestinationMapEntry) {
            DestinationMapEntry thatEntry = (DestinationMapEntry)that;
            return ActiveMQDestination.compare(this.destination, thatEntry.destination);
        }
        if (that == null) {
            return 1;
        }
        return this.getClass().getName().compareTo(that.getClass().getName());
    }

    public void setQueue(String name) {
        this.setDestination(new ActiveMQQueue(name));
    }

    public void setTopic(String name) {
        this.setDestination(new ActiveMQTopic(name));
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.destination == null) {
            throw new IllegalArgumentException("You must specify the 'destination' property");
        }
    }

    public Object getValue() {
        return this;
    }
}

