/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.webservice.configuration;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.gcube.accounting.common.file.FileWatcher;
import org.gcube.accounting.security.SecurityManager;
import org.gcube.accounting.security.authn.DummyAuthenticationManager;
import org.gcube.accounting.security.authn.FileAuthenticationManager;
import org.gcube.accounting.security.authz.FileAuthorizationManager;
import org.gcube.accounting.webservice.configuration.ConfigurationResource;
import org.gcube.accounting.webservice.configuration.NetworkConfiguration;
import org.gcube.accounting.webservice.configuration.SecurityConfiguration;

public class CommonConfigurator {
    private static Logger logger = Logger.getLogger(CommonConfigurator.class);
    private FileWatcher fw;

    public void configureLogging(String logFileName) {
        try {
            PropertyConfigurator.configure(ConfigurationResource.getConfigurationLocation() + "/" + logFileName);
            logger.info("Logging initialized using file: " + ConfigurationResource.getConfigurationLocation() + "/" + logFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void configureProxy(NetworkConfiguration configuration) {
        if (configuration.getProxyHost() != null) {
            logger.info("HTTP proxy support is ON");
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", configuration.getProxyHost());
            if (configuration.getProxyPort() != null) {
                System.setProperty("http.proxyPort", configuration.getProxyPort());
            }
            if (configuration.getProxyUser() != null) {
                System.setProperty("http.proxyUser", configuration.getProxyUser());
            }
            if (configuration.getProxyPassword() != null) {
                System.setProperty("http.proxyPassword", configuration.getProxyPassword());
            }
        } else {
            logger.info("HTTP proxy support is OFF");
            System.setProperty("proxySet", "false");
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
            System.setProperty("http.proxyUser", "");
            System.setProperty("http.proxyPassword", "");
        }
    }

    public void configureAuthentication(SecurityConfiguration configuration) {
        logger.info("Using authentication: " + configuration.isAuthnEnabled());
        if (configuration.isAuthnEnabled()) {
            String authenticationType = configuration.getString("authn.type");
            SecurityManager.setAuthnType(authenticationType);
            logger.info(String.format("Using %s authentication", authenticationType));
            String authorityType = configuration.getString("authn.authority.type");
            logger.info("authentication authority type is: " + authorityType);
            if ("file".equals(authorityType)) {
                String path = configuration.getString("authn.authority.file.path");
                logger.info("using file: " + path);
                try {
                    FileAuthenticationManager authnMng = new FileAuthenticationManager(path);
                    authnMng.setRealm(configuration.getRealm());
                    SecurityManager.setAuthenticationManager(authnMng);
                }
                catch (ConfigurationException e) {
                    logger.error(e.getMessage(), e);
                }
            } else if ("skip".equals(authorityType)) {
                logger.info("using container security");
                DummyAuthenticationManager authMng = new DummyAuthenticationManager();
                authMng.setRealm(configuration.getRealm());
                SecurityManager.setAuthenticationManager(authMng);
            } else {
                logger.error("authz authority type not supported");
            }
        }
        SecurityManager.setAuthnEnabled(configuration.isAuthnEnabled());
    }

    public void configureAuthorization(SecurityConfiguration configuration) {
        logger.info("Using authorization: " + configuration.isAuthzEnabled());
        if (configuration.isAuthzEnabled()) {
            String authorityType = configuration.getString("authz.authority.type");
            logger.info("authorization authority type is: " + authorityType);
            if ("file".equals(authorityType)) {
                String path = configuration.getString("authz.authority.file.path");
                logger.info("using file: " + path);
                try {
                    FileAuthorizationManager authzMng = new FileAuthorizationManager(path);
                    this.fw = new FileWatcher(path);
                    this.fw.setInterval(60000L);
                    this.fw.setListener(authzMng);
                    SecurityManager.setAuthorizationManager(authzMng);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            } else {
                logger.error("authz authority type not supported");
            }
        }
        SecurityManager.setAuthzEnabled(configuration.isAuthzEnabled());
    }

    public void destroy() {
        if (this.fw != null) {
            this.fw.stop();
        }
    }
}

