/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.messaging.endpoints;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointRetriever
implements Runnable {
    Logger logger = LoggerFactory.getLogger(EndpointRetriever.class);
    private ArrayList<String> brokerEndpoints = new ArrayList();
    private List<ServiceEndpoint.AccessPoint> accessPointList;
    String scope = null;

    public EndpointRetriever(String scope) {
        this.scope = scope;
    }

    public List<ServiceEndpoint.AccessPoint> retrieveMessageBrokerEndpoints() throws Exception {
        if (this.accessPointList != null) {
            this.logger.info("cache access point found : " + this.accessPointList);
            return this.accessPointList;
        }
        ScopeProvider.instance.set(this.scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'MessageBroker'");
        DiscoveryClient<ServiceEndpoint> client = ICFactory.clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> resources = client.submit(query);
        if (resources.size() > 0) {
            ServiceEndpoint se = resources.get(0);
            ServiceEndpoint.Profile profile = se.profile();
            if (profile != null) {
                this.accessPointList = new ArrayList<ServiceEndpoint.AccessPoint>();
                for (ServiceEndpoint.AccessPoint ap : profile.accessPoints()) {
                    this.accessPointList.add(ap);
                }
                return this.accessPointList;
            }
            throw new Exception("No MessageBroker Endpoints are available");
        }
        throw new Exception("No MessageBroker Endpoints are available");
    }

    public synchronized ArrayList<String> getEndpoints() {
        return this.brokerEndpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<String> endpoints = new ArrayList<String>();
        try {
            for (ServiceEndpoint.AccessPoint point : this.retrieveMessageBrokerEndpoints()) {
                this.logger.debug(point.address());
                endpoints.add(point.address());
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Message Broker Endpoints", e);
            return;
        }
        if (endpoints.size() != 0) {
            ArrayList<String> arrayList = this.brokerEndpoints;
            synchronized (arrayList) {
                this.brokerEndpoints.clear();
                for (String endpoint : endpoints) {
                    this.brokerEndpoints.add(endpoint);
                }
            }
        }
    }
}

