/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AnyServerSelector;
import com.mongodb.Cluster;
import com.mongodb.ClusterConnectionMode;
import com.mongodb.ClusterDescription;
import com.mongodb.ClusterSettings;
import com.mongodb.ClusterType;
import com.mongodb.Clusters;
import com.mongodb.CommandResult;
import com.mongodb.CompositeServerSelector;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBDecoder;
import com.mongodb.DBPort;
import com.mongodb.DBPortPool;
import com.mongodb.LatencyMinimizingServerSelector;
import com.mongodb.Mongo;
import com.mongodb.MongoAuthority;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.MongosHAServerSelector;
import com.mongodb.OutMessage;
import com.mongodb.ReadPreference;
import com.mongodb.ReadPreferenceServerSelector;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.Response;
import com.mongodb.Server;
import com.mongodb.ServerAddress;
import com.mongodb.ServerAddressSelector;
import com.mongodb.ServerDescription;
import com.mongodb.ServerError;
import com.mongodb.ServerSelector;
import com.mongodb.ServerSettings;
import com.mongodb.SocketSettings;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.util.Assertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DBTCPConnector
implements DBConnector {
    private static final AtomicInteger NEXT_CLUSTER_ID = new AtomicInteger(1);
    private volatile boolean _closed;
    private final Mongo _mongo;
    private Cluster cluster;
    private final MyPort _myPort = new MyPort();
    private final ClusterConnectionMode connectionMode;
    private ClusterType type = ClusterType.Unknown;
    private MongosHAServerSelector mongosHAServerSelector;

    public DBTCPConnector(Mongo mongo) {
        this._mongo = mongo;
        this.connectionMode = this._mongo.getAuthority().getType() == MongoAuthority.Type.Set || this._mongo.getMongoOptions().getRequiredReplicaSetName() != null ? ClusterConnectionMode.Multiple : ClusterConnectionMode.Single;
    }

    public void start() {
        Assertions.isTrue("open", !this._closed);
        MongoOptions options = this._mongo.getMongoOptions();
        String clusterId = Integer.toString(NEXT_CLUSTER_ID.getAndIncrement());
        this.cluster = Clusters.create(clusterId, ClusterSettings.builder().hosts(this._mongo.getAuthority().getServerAddresses()).mode(this.connectionMode).requiredReplicaSetName(this._mongo.getMongoOptions().getRequiredReplicaSetName()).build(), ServerSettings.builder().heartbeatFrequency(options.heartbeatFrequencyMS, TimeUnit.MILLISECONDS).heartbeatConnectRetryFrequency(options.heartbeatConnectRetryFrequencyMS, TimeUnit.MILLISECONDS).heartbeatSocketSettings(SocketSettings.builder().connectTimeout(options.heartbeatConnectTimeoutMS, TimeUnit.MILLISECONDS).readTimeout(options.heartbeatReadTimeoutMS, TimeUnit.MILLISECONDS).socketFactory(this._mongo.getMongoOptions().getSocketFactory()).build()).build(), null, this._mongo);
    }

    @Override
    public void requestStart() {
        Assertions.isTrue("open", !this._closed);
        this._myPort.requestStart();
    }

    @Override
    public void requestDone() {
        Assertions.isTrue("open", !this._closed);
        this._myPort.requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        Assertions.isTrue("open", !this._closed);
        this._myPort.requestEnsureConnection();
    }

    private WriteResult _checkWriteError(DB db, DBPort port, WriteConcern concern) throws IOException {
        CommandResult e = port.runCommand(db, concern.getCommand());
        e.throwOnError();
        return new WriteResult(e, concern);
    }

    @Override
    public WriteResult say(DB db, OutMessage m, WriteConcern concern) {
        Assertions.isTrue("open", !this._closed);
        return this.say(db, m, concern, (ServerAddress)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult say(DB db, OutMessage m, WriteConcern concern, ServerAddress hostNeeded) {
        Assertions.isTrue("open", !this._closed);
        DBPort port = this._myPort.get(true, ReadPreference.primary(), hostNeeded);
        try {
            WriteResult writeResult = this.say(db, m, concern, port);
            return writeResult;
        }
        finally {
            this._myPort.done(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WriteResult say(final DB db, final OutMessage m, final WriteConcern concern, final DBPort port) {
        Assertions.isTrue("open", !this._closed);
        if (concern == null) {
            throw new IllegalArgumentException("Write concern is null");
        }
        try {
            WriteResult writeResult = this.doOperation(db, port, new DBPort.Operation<WriteResult>(){

                @Override
                public WriteResult execute() throws IOException {
                    port.say(m);
                    if (concern.callGetLastError()) {
                        return DBTCPConnector.this._checkWriteError(db, port, concern);
                    }
                    return new WriteResult(db, port, concern);
                }
            });
            return writeResult;
        }
        catch (MongoException.Network e) {
            if (concern.raiseNetworkErrors()) {
                throw e;
            }
            CommandResult res = new CommandResult(port.serverAddress());
            res.put("ok", (Object)false);
            res.put("$err", (Object)"NETWORK ERROR");
            WriteResult writeResult = new WriteResult(res, concern);
            return writeResult;
        }
        finally {
            m.doneWithMessage();
        }
    }

    <T> T doOperation(DB db, DBPort port, DBPort.Operation<T> operation) {
        Assertions.isTrue("open", !this._closed);
        try {
            port.checkAuth(db.getMongo());
            return operation.execute();
        }
        catch (MongoException re) {
            throw re;
        }
        catch (IOException ioe) {
            this._myPort.error(port, ioe);
            throw new MongoException.Network("Operation on server " + port.getAddress() + " failed", ioe);
        }
        catch (RuntimeException re) {
            this._myPort.error(port, re);
            throw re;
        }
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, DBDecoder decoder) {
        Assertions.isTrue("open", !this._closed);
        return this.call(db, coll, m, hostNeeded, 2, null, decoder);
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries) {
        Assertions.isTrue("open", !this._closed);
        return this.call(db, coll, m, hostNeeded, retries, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries, ReadPreference readPref, DBDecoder decoder) {
        Assertions.isTrue("open", !this._closed);
        try {
            Response response = this.innerCall(db, coll, m, hostNeeded, retries, readPref, decoder);
            return response;
        }
        finally {
            m.doneWithMessage();
        }
    }

    private Response innerCall(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int remainingRetries, ReadPreference readPref, DBDecoder decoder) {
        if (readPref == null) {
            readPref = ReadPreference.primary();
        }
        if (readPref == ReadPreference.primary() && m.hasOption(4)) {
            readPref = ReadPreference.secondaryPreferred();
        }
        DBPort port = this._myPort.get(false, readPref, hostNeeded);
        Response res = null;
        boolean retry = false;
        try {
            port.checkAuth(db.getMongo());
            res = port.call(m, coll, decoder);
            if (res._responseTo != m.getId()) {
                throw new MongoException("ids don't match");
            }
        }
        catch (IOException ioe) {
            this._myPort.error(port, ioe);
            retry = this.shouldRetryQuery(readPref, coll, ioe, remainingRetries);
            if (!retry) {
                throw new MongoException.Network("Read operation to server " + port.host() + " failed on database " + db, ioe);
            }
        }
        catch (RuntimeException re) {
            this._myPort.error(port, re);
            throw re;
        }
        finally {
            this._myPort.done(port);
        }
        if (retry) {
            return this.innerCall(db, coll, m, hostNeeded, remainingRetries - 1, readPref, decoder);
        }
        ServerError err = res.getError();
        if (err != null && err.isNotMasterError()) {
            if (remainingRetries <= 0) {
                throw new MongoException("not talking to master and retries used up");
            }
            return this.innerCall(db, coll, m, hostNeeded, remainingRetries - 1, readPref, decoder);
        }
        return res;
    }

    public ServerAddress getAddress() {
        Assertions.isTrue("open", !this._closed);
        ClusterDescription clusterDescription = this.getClusterDescription();
        if (this.connectionMode == ClusterConnectionMode.Single) {
            return clusterDescription.getAny().get(0).getAddress();
        }
        if (clusterDescription.getPrimaries().isEmpty()) {
            return null;
        }
        return clusterDescription.getPrimaries().get(0).getAddress();
    }

    public List<ServerAddress> getAllAddress() {
        Assertions.isTrue("open", !this._closed);
        return this._mongo._authority.getServerAddresses();
    }

    public List<ServerAddress> getServerAddressList() {
        Assertions.isTrue("open", !this._closed);
        ArrayList<ServerAddress> serverAddressList = new ArrayList<ServerAddress>();
        ClusterDescription clusterDescription = this.getClusterDescription();
        for (ServerDescription serverDescription : clusterDescription.getAll()) {
            serverAddressList.add(serverDescription.getAddress());
        }
        return serverAddressList;
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        Assertions.isTrue("open", !this._closed);
        return this.getType() == ClusterType.ReplicaSet && this.connectionMode == ClusterConnectionMode.Multiple ? new ReplicaSetStatus(this.getClusterDescription()) : null;
    }

    boolean isMongosConnection() {
        Assertions.isTrue("open", !this._closed);
        return this.getType() == ClusterType.Sharded;
    }

    public String getConnectPoint() {
        Assertions.isTrue("open", !this._closed);
        ServerAddress master = this.getAddress();
        return master != null ? master.toString() : null;
    }

    private boolean shouldRetryQuery(ReadPreference readPreference, DBCollection coll, IOException ioe, int remainingRetries) {
        if (remainingRetries == 0) {
            return false;
        }
        if (coll._name.equals("$cmd")) {
            return false;
        }
        if (ioe instanceof SocketTimeoutException) {
            return false;
        }
        if (readPreference.equals(ReadPreference.primary())) {
            return false;
        }
        return this.connectionMode == ClusterConnectionMode.Multiple && this.getType() == ClusterType.ReplicaSet;
    }

    private ClusterDescription getClusterDescription() {
        return this.cluster.getDescription(this.getClusterWaitTimeMS(), TimeUnit.MILLISECONDS);
    }

    private int getClusterWaitTimeMS() {
        return Math.min(this._mongo.getMongoOptions().maxWaitTime, this._mongo.getMongoOptions().connectTimeout);
    }

    private int getConnectionWaitTimeMS() {
        return this._mongo.getMongoOptions().maxWaitTime;
    }

    DBPort getPrimaryPort() {
        Assertions.isTrue("open", !this._closed);
        return this._myPort.get(true, ReadPreference.primary(), null);
    }

    void releasePort(DBPort port) {
        Assertions.isTrue("open", !this._closed);
        this._myPort.done(port);
    }

    ServerDescription getServerDescription(ServerAddress address) {
        Assertions.isTrue("open", !this._closed);
        return this.getClusterDescription().getByServerAddress(address);
    }

    private ServerSelector createServerSelector(ReadPreference readPreference) {
        if (this.connectionMode == ClusterConnectionMode.Multiple) {
            ArrayList<ServerSelector> serverSelectorList = new ArrayList<ServerSelector>();
            if (this.getType() == ClusterType.Sharded) {
                serverSelectorList.add(this.getMongosHAServerSelector());
            } else if (this.getType() == ClusterType.ReplicaSet) {
                serverSelectorList.add(new ReadPreferenceServerSelector(readPreference));
            } else {
                serverSelectorList.add(new AnyServerSelector());
            }
            serverSelectorList.add(new LatencyMinimizingServerSelector(this._mongo.getMongoOptions().acceptableLatencyDifferenceMS, TimeUnit.MILLISECONDS));
            return new CompositeServerSelector(serverSelectorList);
        }
        return new AnyServerSelector();
    }

    private synchronized ClusterType getType() {
        if (this.type == ClusterType.Unknown) {
            this.type = this.getClusterDescription().getType();
        }
        return this.type;
    }

    private synchronized MongosHAServerSelector getMongosHAServerSelector() {
        if (this.mongosHAServerSelector == null) {
            this.mongosHAServerSelector = new MongosHAServerSelector();
        }
        return this.mongosHAServerSelector;
    }

    public String debugString() {
        return this.getClusterDescription().getShortDescription();
    }

    public void close() {
        this._closed = true;
        if (this.cluster != null) {
            this.cluster.close();
            this.cluster = null;
        }
    }

    public void updatePortPool(ServerAddress addr) {
    }

    public DBPortPool getDBPortPool(ServerAddress addr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return !this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult authenticate(MongoCredential credentials) {
        DBPort port = this._myPort.get(false, ReadPreference.primaryPreferred(), null);
        try {
            CommandResult result = port.authenticate(this._mongo, credentials);
            this._mongo.getAuthority().getCredentialsStore().add(credentials);
            CommandResult commandResult = result;
            return commandResult;
        }
        finally {
            this._myPort.done(port);
        }
    }

    public int getMaxBsonObjectSize() {
        ClusterDescription clusterDescription = this.getClusterDescription();
        if (clusterDescription.getPrimaries().isEmpty()) {
            return 0x400000;
        }
        return clusterDescription.getPrimaries().get(0).getMaxDocumentSize();
    }

    MyPort getMyPort() {
        return this._myPort;
    }

    private Server getServer(ServerSelector serverSelector) {
        return this.cluster.getServer(serverSelector, this.getClusterWaitTimeMS(), TimeUnit.MILLISECONDS);
    }

    static class PinnedRequestStatus {
        DBPort requestPort;
        public int nestedBindings;

        PinnedRequestStatus() {
        }
    }

    class MyPort {
        private final ThreadLocal<PinnedRequestStatus> pinnedRequestStatusThreadLocal = new ThreadLocal();

        MyPort() {
        }

        DBPort get(boolean keep, ReadPreference readPref, ServerAddress hostNeeded) {
            DBPort pinnedRequestPort = this.getPinnedRequestPortForThread();
            if (hostNeeded != null) {
                if (pinnedRequestPort != null && pinnedRequestPort.serverAddress().equals(hostNeeded)) {
                    return pinnedRequestPort;
                }
                return this.getConnection(new ServerAddressSelector(hostNeeded));
            }
            if (pinnedRequestPort != null) {
                if (this.portIsAPrimary(pinnedRequestPort) || !keep) {
                    return pinnedRequestPort;
                }
                pinnedRequestPort.getProvider().release(pinnedRequestPort);
                this.setPinnedRequestPortForThread(null);
            }
            DBPort port = this.getConnection(DBTCPConnector.this.createServerSelector(readPref));
            if (this.threadHasPinnedRequest()) {
                this.setPinnedRequestPortForThread(port);
            }
            return port;
        }

        private boolean portIsAPrimary(DBPort pinnedRequestPort) {
            for (ServerDescription cur : DBTCPConnector.this.getClusterDescription().getPrimaries()) {
                if (!cur.getAddress().equals(pinnedRequestPort.serverAddress())) continue;
                return true;
            }
            return false;
        }

        void done(DBPort port) {
            DBPort requestPort = this.getPinnedRequestPortForThread();
            if (port != requestPort) {
                port.getProvider().release(port);
            }
        }

        void error(DBPort port, Exception e) {
            if (!(e instanceof InterruptedIOException)) {
                DBTCPConnector.this.getServer(new ServerAddressSelector(port.getAddress())).invalidate();
            }
            port.close();
            this.pinnedRequestStatusThreadLocal.remove();
        }

        void requestEnsureConnection() {
            if (!this.threadHasPinnedRequest()) {
                return;
            }
            if (this.getPinnedRequestPortForThread() != null) {
                return;
            }
            this.setPinnedRequestPortForThread(this.getConnection(DBTCPConnector.this.createServerSelector(ReadPreference.primary())));
        }

        private DBPort getConnection(ServerSelector serverSelector) {
            return (DBPort)DBTCPConnector.this.getServer(serverSelector).getConnection(DBTCPConnector.this.getConnectionWaitTimeMS(), TimeUnit.MILLISECONDS);
        }

        void requestStart() {
            PinnedRequestStatus current = this.getPinnedRequestStatusForThread();
            if (current == null) {
                this.pinnedRequestStatusThreadLocal.set(new PinnedRequestStatus());
            } else {
                ++current.nestedBindings;
            }
        }

        void requestDone() {
            PinnedRequestStatus current = this.getPinnedRequestStatusForThread();
            if (current != null) {
                if (current.nestedBindings > 0) {
                    --current.nestedBindings;
                } else {
                    this.pinnedRequestStatusThreadLocal.remove();
                    if (current.requestPort != null) {
                        current.requestPort.getProvider().release(current.requestPort);
                    }
                }
            }
        }

        PinnedRequestStatus getPinnedRequestStatusForThread() {
            return this.pinnedRequestStatusThreadLocal.get();
        }

        boolean threadHasPinnedRequest() {
            return this.pinnedRequestStatusThreadLocal.get() != null;
        }

        DBPort getPinnedRequestPortForThread() {
            return this.threadHasPinnedRequest() ? this.pinnedRequestStatusThreadLocal.get().requestPort : null;
        }

        void setPinnedRequestPortForThread(DBPort port) {
            this.pinnedRequestStatusThreadLocal.get().requestPort = port;
        }
    }
}

