/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import org.apache.activemq.network.ConduitBridge;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DurableConduitBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.transport.Transport;

public final class NetworkBridgeFactory {
    private NetworkBridgeFactory() {
    }

    public static DemandForwardingBridge createBridge(NetworkBridgeConfiguration config, Transport localTransport, Transport remoteTransport) {
        return NetworkBridgeFactory.createBridge(config, localTransport, remoteTransport, null);
    }

    public static DemandForwardingBridge createBridge(NetworkBridgeConfiguration configuration, Transport localTransport, Transport remoteTransport, NetworkBridgeListener listener) {
        DemandForwardingBridge result = null;
        result = configuration.isConduitSubscriptions() ? (configuration.isDynamicOnly() ? new ConduitBridge(configuration, localTransport, remoteTransport) : new DurableConduitBridge(configuration, localTransport, remoteTransport)) : new DemandForwardingBridge(configuration, localTransport, remoteTransport);
        if (listener != null) {
            result.setNetworkBridgeListener(listener);
        }
        return result;
    }
}

