/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesLoginModule
implements LoginModule {
    private static final String USER_FILE = "org.apache.activemq.jaas.properties.user";
    private static final String GROUP_FILE = "org.apache.activemq.jaas.properties.group";
    private static final Log LOG = LogFactory.getLog(PropertiesLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug;
    private String usersFile;
    private String groupsFile;
    private Properties users = new Properties();
    private Properties groups = new Properties();
    private String user;
    private Set<Principal> principals = new HashSet<Principal>();
    private File baseDir;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.baseDir = System.getProperty("java.security.auth.login.config") != null ? new File(System.getProperty("java.security.auth.login.config")).getParentFile() : new File(".");
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.usersFile = (String)options.get(USER_FILE) + "";
        this.groupsFile = (String)options.get(GROUP_FILE) + "";
        if (this.debug) {
            LOG.debug("Initialized debug=" + this.debug + " usersFile=" + this.usersFile + " groupsFile=" + this.groupsFile + " basedir=" + this.baseDir);
        }
    }

    public boolean login() throws LoginException {
        String password;
        FileInputStream in;
        File f = new File(this.baseDir, this.usersFile);
        try {
            in = new FileInputStream(f);
            this.users.load(in);
            in.close();
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load user properties file " + f);
        }
        f = new File(this.baseDir, this.groupsFile);
        try {
            in = new FileInputStream(f);
            this.groups.load(in);
            in.close();
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load group properties file " + f);
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if ((password = this.users.getProperty(this.user)) == null) {
            throw new FailedLoginException("User does exist");
        }
        if (!password.equals(new String(tmpPassword))) {
            throw new FailedLoginException("Password does not match");
        }
        this.users.clear();
        if (this.debug) {
            LOG.debug("login " + this.user);
        }
        return true;
    }

    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.user));
        Enumeration<Object> enumeration = this.groups.keys();
        block0: while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] userList = (this.groups.getProperty(name) + "").split(",");
            for (int i = 0; i < userList.length; ++i) {
                if (!this.user.equals(userList[i])) continue;
                this.principals.add(new GroupPrincipal(name));
                continue block0;
            }
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            LOG.debug("commit");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.debug("abort");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOG.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.groups.clear();
        this.user = null;
    }
}

