/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.messaging.endpoints;

import java.util.HashMap;
import java.util.Map;
import org.gcube.common.messaging.endpoints.BrokerNotConfiguredInScopeException;
import org.gcube.common.messaging.endpoints.ScheduledRetriever;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerEndpoints {
    static Logger logger = LoggerFactory.getLogger(BrokerEndpoints.class);
    private static Map<String, ScheduledRetriever> map = new HashMap<String, ScheduledRetriever>();

    public static ScheduledRetriever getRetriever(long waitingTime, long refreshTime) throws Exception, BrokerNotConfiguredInScopeException {
        ScheduledRetriever ret = null;
        if (ScopeProvider.instance.get() == null) {
            throw new Exception("Scope not set in current Thread");
        }
        if (map.containsKey(ScopeProvider.instance.get())) {
            ret = map.get(ScopeProvider.instance.get());
        } else {
            ret = new ScheduledRetriever(ScopeProvider.instance.get(), refreshTime);
            long startTime = System.currentTimeMillis();
            while (ret.getEndpoints().size() == 0 && System.currentTimeMillis() - startTime < waitingTime * 1000L) {
                logger.debug("Waiting to retrieve MessageBroker endpoints from IS");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (ret.getEndpoints().size() == 0) {
                ret.scheduler.shutdownNow();
                throw new BrokerNotConfiguredInScopeException("A MessageBroker RuntimeResource for the scope " + ScopeProvider.instance.get() + " was not found on the IS after the given interval");
            }
            map.put(ScopeProvider.instance.get(), ret);
        }
        return ret;
    }

    public static ScheduledRetriever getRetriever() throws Exception {
        if (ScopeProvider.instance.get() == null) {
            throw new Exception("Scope not set in current Thread");
        }
        if (map.containsKey(ScopeProvider.instance.get())) {
            return map.get(ScopeProvider.instance.get());
        }
        throw new Exception("Retriever not instantiated");
    }
}

