/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.store;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.gcube.contentmanager.storageserver.store.StorageStatusObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageStatusOperationManager {
    DBCollection ssCollection;
    Logger logger = LoggerFactory.getLogger(StorageStatusOperationManager.class);

    public StorageStatusOperationManager(DBCollection ssCollection) {
        this.setSsCollection(ssCollection);
    }

    public void putSSRecord(String consumer, long volume, int count) {
        BasicDBObject doc = new BasicDBObject("consumer", consumer).append("volume", volume).append("count", count);
        this.getSsCollection().insert(doc);
    }

    public StorageStatusObject updateUser(StorageStatusObject ssRecord, String lastOperation) {
        StorageStatusObject oldSsr = this.getSSRecord(ssRecord.getConsumer());
        if (oldSsr != null) {
            int partialCount = oldSsr.getCount();
            int count = this.countCalculation(ssRecord.getCount(), partialCount, lastOperation);
            ssRecord.setCount(count);
            long partialVolume = oldSsr.getVolume();
            long volume = this.volumeCalculation(ssRecord.getVolume(), partialVolume, lastOperation);
            ssRecord.setVolume(volume);
            BasicDBObject query = new BasicDBObject("consumer", ssRecord.getConsumer());
            DBObject documentBuilder = BasicDBObjectBuilder.start().add("volume", volume).add("count", count).get();
            this.getSsCollection().update(query, new BasicDBObject("$set", documentBuilder), true, false);
        } else {
            this.putSSRecord(ssRecord.getConsumer(), ssRecord.getVolume(), ssRecord.getCount());
        }
        return ssRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageStatusObject getSSRecord(String consumer) {
        BasicDBObject query = new BasicDBObject("consumer", consumer);
        DBObject obj = null;
        try (DBCursor cursor = this.getSsCollection().find(query);){
            if (cursor.hasNext()) {
                obj = cursor.next();
            }
        }
        if (obj != null) {
            String cons = null;
            if (obj.containsField("consumer")) {
                cons = (String)obj.get("consumer");
            } else {
                this.logger.error("incomplete record found. consumer field is missing");
            }
            long vol = 0L;
            if (obj.containsField("volume")) {
                vol = (Long)obj.get("volume");
            } else {
                this.logger.error("incomplete record found. volume field is missing");
            }
            int count = 0;
            if (obj.containsField("count")) {
                count = (Integer)obj.get("count");
            } else {
                this.logger.error("incomplete record found. count field is missing");
            }
            String id = (String)obj.get("id");
            return new StorageStatusObject(id, cons, vol, count, obj);
        }
        return null;
    }

    private long volumeCalculation(long currentVolume, long partialVolume, String operation) {
        this.logger.debug("accounting: operation " + operation + " total Volume " + partialVolume + " current volume " + currentVolume);
        if (operation.equalsIgnoreCase("UPLOAD") || operation.equalsIgnoreCase("COPY")) {
            partialVolume += currentVolume;
        } else if (operation.equalsIgnoreCase("DELETE")) {
            partialVolume -= currentVolume;
        }
        this.logger.debug("new volume " + partialVolume);
        return partialVolume;
    }

    private int countCalculation(int currentCount, int partialCount, String operation) {
        this.logger.debug("accounting: operation " + operation + " total count " + partialCount + " current count" + currentCount);
        if (operation.equalsIgnoreCase("UPLOAD") || operation.equalsIgnoreCase("COPY")) {
            partialCount += currentCount;
        } else if (operation.equalsIgnoreCase("DELETE")) {
            partialCount -= currentCount;
        }
        this.logger.debug("new count: " + partialCount);
        return partialCount;
    }

    public DBCollection getSsCollection() {
        return this.ssCollection;
    }

    public void setSsCollection(DBCollection ssCollection) {
        this.ssCollection = ssCollection;
    }
}

