/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class SearchQueryRow {
    private final String index;
    private final String id;
    private final double score;
    private final String explanation;
    private final Map<String, Map<String, List<Location>>> locations;
    private final Map<String, String[]> fragments;
    private final Map<String, Object> fields;

    public SearchQueryRow(String index, String id, double score, String explanation, Map<String, Map<String, List<Location>>> locations, Map<String, String[]> fragments, Map<String, Object> fields) {
        this.index = index;
        this.id = id;
        this.score = score;
        this.explanation = explanation;
        this.locations = locations;
        this.fragments = fragments;
        this.fields = fields;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SearchQueryHit{id='" + this.id + "', score=" + this.score + ", fragments={");
        if (this.fragments != null) {
            boolean addDelim = false;
            for (Map.Entry<String, String[]> fragment : this.fragments.entrySet()) {
                if (addDelim) {
                    sb.append(", ");
                } else {
                    addDelim = true;
                }
                sb.append("\"" + fragment.getKey() + "\":" + JsonArray.from(fragment.getValue()).toString());
            }
        }
        return sb.append("}}").toString();
    }

    public String index() {
        return this.index;
    }

    public String id() {
        return this.id;
    }

    public double score() {
        return this.score;
    }

    public String explanation() {
        return this.explanation;
    }

    public Map<String, Map<String, List<Location>>> locations() {
        return this.locations;
    }

    public Map<String, String[]> fragments() {
        return this.fragments;
    }

    public Map<String, Object> fields() {
        return this.fields;
    }

    public static class Location {
        private final long pos;
        private final long start;
        private final long end;
        private final long[] arrayPositions;

        public Location(long pos, long start, long end, long[] arrayPositions) {
            this.pos = pos;
            this.start = start;
            this.end = end;
            this.arrayPositions = arrayPositions;
        }

        public long position() {
            return this.pos;
        }

        public long start() {
            return this.start;
        }

        public long end() {
            return this.end;
        }

        public long[] arrayPositions() {
            return this.arrayPositions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Location{");
            sb.append("position=").append(this.pos);
            sb.append(", start=").append(this.start);
            sb.append(", end=").append(this.end);
            sb.append(", arrayPositions=").append(Arrays.toString(this.arrayPositions));
            sb.append('}');
            return sb.toString();
        }
    }
}

