package org.gcube.contentmanager.storageclient.wrapper;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;

public class StorageClient {

	private GCUBEScope scope;
	private String clientID;
// public | private | shared. If shared the rwx permits are extended to all services of the same type
	private String typeAccess;
	private String memoryType;
	private String serviceClass;
	private String serviceName;
	private String owner;
	private String server;
	
	private static final GCUBELog logger=new GCUBELog(StorageClient.class);
	
	/**
	 * 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, GCUBEScope scope, String server){
		String id=owner;
		this.owner=owner;
		this.scope=scope;
		this.typeAccess=accessType.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		this.server=server;
		if(typeAccess.equalsIgnoreCase("public")){
			;
		}else if(typeAccess.equalsIgnoreCase("private")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName+ServiceEngine.FILE_SEPARATOR+id;
		}else if(typeAccess.equalsIgnoreCase("shared")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName;
		}else{
			throw new IllegalArgumentException("type is not correctly: public, private or shared");
		}
		
	}
	
	/**
	 * 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param memory defines the kind of memory: VOLATILE or PERSISTENT
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, GCUBEScope scope, String server, MemoryType memory){
		String id=owner;
		this.owner=owner;
		this.scope=scope;
		this.typeAccess=accessType.toString();
		this.memoryType=memory.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		this.server=server;
		if(typeAccess.equalsIgnoreCase("public")){
			;
		}else if(typeAccess.equalsIgnoreCase("private")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName+ServiceEngine.FILE_SEPARATOR+id;
		}else if(typeAccess.equalsIgnoreCase("shared")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName;
		}else{
			throw new IllegalArgumentException("type is not correctly: public, private or shared");
		}
	}

	
	/**
	 * 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, String server){
		String id=owner;
		this.owner=owner;
		this.scope=GCUBEScope.getScope(scope);
		this.typeAccess=accessType.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		this.server=server;
		if(typeAccess.equalsIgnoreCase("public")){
			;
		}else if(typeAccess.equalsIgnoreCase("private")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName+ServiceEngine.FILE_SEPARATOR+id;
		}else if(typeAccess.equalsIgnoreCase("shared")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName;
		}else{
			throw new IllegalArgumentException("type is not correctly: public, private or shared");
		}
		
	}

	
	/**
	 * 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param memory defines the kind of memory: VOLATILE or PERSISTENT
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, String server, MemoryType memory){
		String id=owner;
		this.owner=owner;
		this.scope=GCUBEScope.getScope(scope);
		this.typeAccess=accessType.toString();
		this.memoryType=memory.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		this.server=server;
		if(typeAccess.equalsIgnoreCase("public")){
			;
		}else if(typeAccess.equalsIgnoreCase("private")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName+ServiceEngine.FILE_SEPARATOR+id;
		}else if(typeAccess.equalsIgnoreCase("shared")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName;
		}else{
			throw new IllegalArgumentException("type is not correctly: public, private or shared");
		}
	}
	
	
	
	/**
	 * 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, GCUBEScope scope){
		String id=owner;
		this.owner=owner;
		this.scope=scope;
		this.typeAccess=accessType.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		if(typeAccess.equalsIgnoreCase("public")){
			;
		}else if(typeAccess.equalsIgnoreCase("private")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName+ServiceEngine.FILE_SEPARATOR+id;
		}else if(typeAccess.equalsIgnoreCase("shared")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName;
		}else{
			throw new IllegalArgumentException("type is not correctly: public, private or shared");
		}
		
	}
	
	
	/**
	 * 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param memory defines the kind of memory: VOLATILE or PERSISTENT
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, GCUBEScope scope, MemoryType memory){
		String id=owner;
		this.owner=owner;
		this.scope=scope;
		this.typeAccess=accessType.toString();
		this.memoryType=memory.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		if(typeAccess.equalsIgnoreCase("public")){
			;
		}else if(typeAccess.equalsIgnoreCase("private")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName+ServiceEngine.FILE_SEPARATOR+id;
		}else if(typeAccess.equalsIgnoreCase("shared")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName;
		}else{
			throw new IllegalArgumentException("type is not correctly: public, private or shared");
		}
	}
	
	
	/**
	 * 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope){
		String id=owner;
		this.owner=owner;
		this.scope=GCUBEScope.getScope(scope);
		this.typeAccess=accessType.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		if(typeAccess.equalsIgnoreCase("public")){
			;
		}else if(typeAccess.equalsIgnoreCase("private")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName+ServiceEngine.FILE_SEPARATOR+id;
		}else if(typeAccess.equalsIgnoreCase("shared")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName;
		}else{
			throw new IllegalArgumentException("type is not correctly: public, private or shared");
		}
		
	}
	
	
	/**
	 * 
	 * @param ServiceClass 
	 * @param ServiceName
	 * @param owner
	 * @param typeAccess
	 * @param scope
	 */
	public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, MemoryType memory){
		String id=owner;
		this.owner=owner;
		this.scope=GCUBEScope.getScope(scope);
		this.typeAccess=accessType.toString();
		this.memoryType= memory.toString();
		this.serviceClass=serviceClass;
		this.serviceName=serviceName;
		if(typeAccess.equalsIgnoreCase("public")){
			;
		}else if(typeAccess.equalsIgnoreCase("private")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName+ServiceEngine.FILE_SEPARATOR+id;
		}else if(typeAccess.equalsIgnoreCase("shared")){
			clientID=serviceClass+ServiceEngine.FILE_SEPARATOR+serviceName;
		}else{
			throw new IllegalArgumentException("type is not correctly: public, private or shared");
		}
	}
	
	
	public IClient getClient() throws Exception{
		String[]  newServer=null;
		if(server==null){
			String[] serverFounded=checkVarEnvMongo();
			if(serverFounded==null){
				ISClientConnector isclient=new ISClientConnector();
				serverFounded=isclient.getServer("StorageManager", scope);
			}
			newServer=serverFounded;
		}else{
			String[] serverPassed={server};
			newServer=serverPassed;
		}
		if(newServer==null){
			throw new Exception("Generic resource not found");
		}else{
			String environment=scope.getName();
			if((memoryType != null) && (memoryType.toString().equalsIgnoreCase("VOLATILE"))){
				environment="VOLATILE"+ServiceEngine.FILE_SEPARATOR+scope.getName();
			}
			ServiceEngine engine= new ServiceEngine(newServer, clientID, environment, typeAccess, owner);
			engine.setServiceClass(serviceClass);
			engine.setServiceName(serviceName);
			engine.setGcubeAccessType(typeAccess.toLowerCase());
			if(memoryType!=null)
				engine.setGcubeMemoryType(memoryType.toLowerCase());
			engine.setGcubeScope(scope.toString());
			engine.setOwnerGcube(owner);
			return engine;
		}
	}	

	
	private String[] checkVarEnvMongo(){
		Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        
        Iterator<String> iter = keys.iterator();
        String server=null;
        while(iter.hasNext())
        {
            String key = iter.next();
            if(key.equalsIgnoreCase("STORAGE_MANAGER_MONGO_SERVER")){
            	server=env.get(key);
            }
        }
        if(server!=null){
        	 String [] servers={server};
        	 return servers;
        }
        return null;
	}
	
}