package org.gcube.contentmanagement.storage.data.transfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.storage.data.transfer.utils.Utils;

public class FileTransfer {

	/**
	 * Transfer a single file from local to the gcube production storage cluster.
	 * The remote storage area is buonded in home-library area on the storage
	 * @param args
	 */
	public static void main(String[] args) {
		for (int i=0; i<args.length;i++) 
			System.out.println("param N." +i + ": " + args[i]);		
		if(args.length != 2 ){
			System.out.println("Usage:");
			System.out.println("\tjava  org.gcube.contentmanagement.storage.data.transfer.FileTransfer localFilePath remoteFilePath\n\n");
			System.out.println("Example:");
			System.out.println("\tjava  org.gcube.contentmanagement.storage.data.transfer.FileTransfer /home/rcirillo/test.jpg /Share/test/test.jpg \n\n");
			return;
		}
		IClient prodClient=Utils.getProductionStorageClient();
		prodClient.put(true).LFile(args[0]).RFile(args[1]);

	}

	private static void redirectStdOutput(String path) {
		File file = new File("src/main/resources/logStorageTrasf20131218.txt");  
		FileOutputStream fis = null;
		try {
			fis = new FileOutputStream(file);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}  
		PrintStream out = new PrintStream(fis);  
		System.setOut(out);
	}

}
