package org.gcube.contentmanagement.timeseriesservice.calls.codelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.timeseriesservice.calls.Constant;
import org.gcube.contentmanagement.timeseriesservice.calls.NoServiceFoundException;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLUnderCurationItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLUnderCurationItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.ChangeColumnTypeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CheckNullValuesOnDataTypeChangeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodeListType;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnType;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.DataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistCurationManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistIdentifier;
import org.gcube.contentmanagement.timeseriesservice.stubs.EnterInEditModeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.RemoveColumnRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ReplaceValueRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetCLLabelRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.StartCurationModeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.CodelistCurationManagerServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Order;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetPropertiesRequest;

public class CodelistCurationCall extends CodeListCall {

	
	
	
	private static String getEndpoint() {
		return "gcube/contentmanagement/timeseriesservice/codelist/CodelistCuration";
	}



	private static  HashMap<String, CodelistCurationManagerPortType> clCurationManagerPTMapping= new HashMap<String, CodelistCurationManagerPortType>();
	private String user;
	private String id;
	private CodelistCurationManagerPortType cachedPT;

	
	/**
	 * 
	 * @param scope
	 * @param epr
	 * @throws NoServiceFoundException
	 * @throws Exception
	 */
	public static void setPT(GCUBEScope scope, EndpointReferenceType epr) throws NoServiceFoundException, Exception{
		CodelistCurationManagerPortType pt = new CodelistCurationManagerServiceAddressingLocator().getCodelistCurationManagerPortTypePort(epr);
		pt= GCUBERemotePortTypeContext.getProxy(pt, scope);
		clCurationManagerPTMapping.put(scope.toString(),pt);
	}

	/**
	 * 
	 * @param scope
	 * @param securityManager
	 * @return
	 * @throws NoServiceFoundException
	 * @throws Exception
	 */
	private static CodelistCurationManagerPortType getCodelistCurationManagerPortType(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception{
		if (clCurationManagerPTMapping.get(scope.toString())==null){
			CodelistCurationManagerPortType pt = new CodelistCurationManagerServiceAddressingLocator().getCodelistCurationManagerPortTypePort(getEpr(scope, getEndpoint()));
			pt= GCUBERemotePortTypeContext.getProxy(pt, scope, securityManager);
			clCurationManagerPTMapping.put(scope.toString(),pt);
		}
		return	clCurationManagerPTMapping.get(scope.toString());

	}

	/**
	 * 
	 * @param importId
	 * @param user
	 * @param scope
	 * @param securityManagers
	 * @return
	 * @throws NoServiceFoundException
	 * @throws Exception
	 */
	public static String startCurationMode(String importId, String user, CodeListType type,  GCUBEScope scope, GCUBESecurityManager ...securityManagers) throws NoServiceFoundException, Exception {
		CodelistCurationManagerPortType pt = getCodelistCurationManagerPortType(scope, securityManagers);
		return pt.startCurationMode(new StartCurationModeRequest(type, importId, user));
	}

	/**
	 * 
	 * @param user
	 * @param scope
	 * @param securityManager
	 * @return
	 * @throws NoServiceFoundException
	 * @throws Exception
	 */
	public static List<CLUnderCurationItem> getItems(String user, GCUBEScope scope, GCUBESecurityManager ... securityManager ) throws NoServiceFoundException, Exception{
		CLUnderCurationItemsArray clArray = getCodelistCurationManagerPortType(scope,securityManager).getUnderCurationCodelists(user);
		if (clArray.getItems() == null) return  new ArrayList<CLUnderCurationItem>();
		return Arrays.asList(clArray.getItems());
	}
	
	/**
	 * 
	 * @param id
	 * @param user
	 * @param scope
	 * @param securityManager
	 * @return
	 * @throws NoServiceFoundException
	 * @throws Exception
	 */
	public static CLUnderCurationItem getItem(String id, String user, GCUBEScope scope, GCUBESecurityManager ... securityManager ) throws NoServiceFoundException, Exception{
		return getCodelistCurationManagerPortType(scope,securityManager).getCLUnderCurationItem(new CodelistIdentifier(id, user));
	}
	
	public CodelistCurationCall(String user, String id, GCUBEScope scope, GCUBESecurityManager ... securityManagers) throws NoServiceFoundException, Exception{
		this.id= id;
		this.user = user;
		cachedPT = getCodelistCurationManagerPortType(scope, securityManagers);
	}
		
	/**
	 * 
	 * @param fieldId
	 * @throws Exception
	 */
	public void removeColumn(String fieldId) throws Exception{
		cachedPT.removeColumn(new RemoveColumnRequest(fieldId, new CodelistIdentifier(id, user)));
	}

	/**
	 * 
	 * @param rows
	 * @throws Exception
	 */
	public void removeRow(int ... rows) throws Exception {
		
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public boolean checkCodeListCurationFinished() throws Exception{
		return cachedPT.checkCodeListCurationFinished(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public boolean remove() throws Exception {
		return cachedPT.remove(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public List<CodelistColumnDefinition> getColumnsDefinition() throws Exception{
		List<CodelistColumnDefinition> toReturn = new ArrayList<CodelistColumnDefinition>();
		for (CodelistColumnDefinition cdef: cachedPT.getColumnsDefinition(new CodelistIdentifier(id, user)).getDefinition())
			toReturn.add(cdef);
		return toReturn;
	}
	
	/**
	 * 
	 * @param limit
	 * @param order
	 * @return
	 * @throws Exception
	 */
	public String getDataAsJson(Limit limit, Order order) throws Exception{
		Exception exception;
		int tries = 0;
		do{
			try{
				return cachedPT.getDataAsJson(new DataAsJsonRequest(new CodelistIdentifier(id, user), limit, order));
			}catch (Exception e) {
				tries++;
				exception=e;
			}
		}while(tries<Constant.MAX_TRIES);
		throw exception;
	}
		
	/**
	 * 
	 * @param fieldId
	 * @param columnType
	 * @throws Exception
	 */
	public void changeColumnType(String fieldId, CodelistColumnType columnType) throws Exception{
		cachedPT.changeColumnType(new ChangeColumnTypeRequest(columnType, fieldId, new CodelistIdentifier(id, user), null));
	}
	
	/**
	 * 
	 * @param fieldId
	 * @param columnType
	 * @throws Exception
	 */
	public void changeColumnType(String fieldId, CodelistColumnType columnType, String codeListReferenceId) throws Exception{
		cachedPT.changeColumnType(new ChangeColumnTypeRequest(columnType, fieldId, new CodelistIdentifier(id, user), codeListReferenceId));
	}
	
	/**
	 * 
	 * @param fieldId
	 * @param newType
	 * @return
	 * @throws Exception
	 */
	public int checkCorrectness(String fieldId, DataType newType) throws Exception{
		return cachedPT.checkNullValuesOnDataTypeChange(new CheckNullValuesOnDataTypeChangeRequest(null, null ,newType, fieldId, new CodelistIdentifier(id, user)));
	}
	
	public int checkCorrectness(String fieldId, CodelistColumnType columnType, String relatedCodelistId) throws Exception{
		return cachedPT.checkNullValuesOnDataTypeChange(new CheckNullValuesOnDataTypeChangeRequest(relatedCodelistId, columnType, null, fieldId, new CodelistIdentifier(id, user)));
	}
	
	/**
	 * 
	 * @param fieldId
	 * @param newType
	 * @throws Exception
	 */
	public void edit(String fieldId, DataType newType) throws Exception {
		cachedPT.enterInEditMode(new EnterInEditModeRequest(newType, fieldId, new CodelistIdentifier(id, user)));
	}
	
	/**
	 * 
	 * @param fieldId
	 * @param newType
	 * @throws Exception
	 */
	public void edit(String fieldId) throws Exception {
		cachedPT.enterInEditMode(new EnterInEditModeRequest(null, fieldId, new CodelistIdentifier(id, user)));
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public Status getEditingStatus() throws Exception {
		return cachedPT.getEditingStatus(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public boolean isUnderEditing() throws Exception {
		return cachedPT.isUnderEditing(new CodelistIdentifier(id, user));
	}

	/**
	 * 
	 * @throws Exception
	 */
	public void removeEdit() throws Exception {
		cachedPT.removeEdit(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @param newValue
	 * @param rowId
	 * @param fieldId
	 * @throws Exception
	 */
	public void replaceValue(String newValue, int rowId, String fieldId) throws Exception {
		cachedPT.replaceValue(new ReplaceValueRequest(fieldId, new CodelistIdentifier(id, user), newValue, rowId));
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public CodelistColumnDefinition getColumnInEditMode() throws Exception{
		return cachedPT.getColumnDefinitionUnderEdit(new CodelistIdentifier(id, user));
	}
	
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public int getErrorCount() throws Exception{
		return cachedPT.getErrorCount(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public int getSize() throws Exception{
		return cachedPT.getSize(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @throws Exception
	 */
	public void removeAllErrors() throws Exception{
		cachedPT.removeAllErrors(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @throws Exception
	 */
	public void saveEditing() throws Exception{
		cachedPT.saveEdit(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @param fieldId
	 * @param label
	 * @throws Exception
	 */
	public void setLabel(String fieldId, String label) throws Exception{
		cachedPT.setLabel(new SetCLLabelRequest(fieldId, new CodelistIdentifier(id, user), label));
	}
		
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public Status getCurationStatus() throws Exception{
		return cachedPT.getCurationStatus(new CodelistIdentifier(id, user));
	}

	public void setProperties(String agencyId, String description, boolean isFinal, String name, float version) throws Exception{
		cachedPT.setProperties(new SetPropertiesRequest(agencyId, description,  new CodelistIdentifier(id, user), isFinal, name, version));
	}
	
	public String getCodes(Limit limit, Order order) throws Exception{
		return cachedPT.getCodes(new DataAsJsonRequest( new CodelistIdentifier(id, user), limit, order));
	}
}
