package org.gcube.contentmanagement.timeseriesservice.calls.codelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.timeseriesservice.calls.Constant;
import org.gcube.contentmanagement.timeseriesservice.calls.NoServiceFoundException;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLImportedItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLImportedItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistImportManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportFromCsvRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportFromSdmxRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportStatusResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistIdentifier;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.DataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.CodelistImportManagerServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;



public class CodelistImportCall extends CodeListCall{

	


	private static String getEndpoint() {
		return "gcube/contentmanagement/timeseriesservice/codelist/CodelistImport";
	}
	
	
	private static  HashMap<String, CodelistImportManagerPortType> clImportManagerPTMapping= new HashMap<String, CodelistImportManagerPortType>();
	private String user;
	private String id;
	private CodelistImportManagerPortType cachedPT;
	
	public static void setPT(GCUBEScope scope, EndpointReferenceType epr) throws NoServiceFoundException, Exception{
		CodelistImportManagerPortType pt = new CodelistImportManagerServiceAddressingLocator().getCodelistImportManagerPortTypePort(epr);
		pt= GCUBERemotePortTypeContext.getProxy(pt, scope);
		clImportManagerPTMapping.put(scope.toString(),pt);
	}
	
	private static CodelistImportManagerPortType getCodelistImportManagerPortType(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception{
		if (clImportManagerPTMapping.get(scope.toString())==null){
			CodelistImportManagerPortType pt = new CodelistImportManagerServiceAddressingLocator().getCodelistImportManagerPortTypePort(getEpr(scope, getEndpoint()));
			pt= GCUBERemotePortTypeContext.getProxy(pt, scope, securityManager);
			clImportManagerPTMapping.put(scope.toString(),pt);
		}
		return	clImportManagerPTMapping.get(scope.toString());
		
	}
	
	public static String importFromCsv(String user, String name, String description,  String delimiter, String encoding,boolean hasHeader, String rsLocator, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception{
		ImportFromCsvRequest csvRequest = new ImportFromCsvRequest();
		csvRequest.setDelimiter(delimiter);
		csvRequest.setEncoding(encoding);
		csvRequest.setHasHeader(hasHeader);
		csvRequest.setOwner(user);
		csvRequest.setRsLocator(rsLocator);
		csvRequest.setName(name);
		csvRequest.setDescription(description);
		return getCodelistImportManagerPortType(scope,securityManager).importFromCsv(csvRequest);
	}
	
	public static String importFromSdmxUri(String user, String sdmxURI,GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception{
		ImportFromSdmxRequest sdmxRequest = new ImportFromSdmxRequest();
		sdmxRequest.setOwner(user);
		sdmxRequest.setSdmxUri(sdmxURI);
		sdmxRequest.setRsLocator(null);
		return getCodelistImportManagerPortType(scope,securityManager).importFromSdmx(sdmxRequest);
	}
	
	
	public static String importFromSdmxFile(String user, String rsLocatorURI,GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception{
		ImportFromSdmxRequest sdmxRequest = new ImportFromSdmxRequest();
		sdmxRequest.setOwner(user);
		sdmxRequest.setRsLocator(rsLocatorURI);
		sdmxRequest.setSdmxUri(null);
		return getCodelistImportManagerPortType(scope,securityManager).importFromSdmx(sdmxRequest);
	}
	
	public static List<CLImportedItem> getItems(String user, GCUBEScope scope, GCUBESecurityManager ... securityManager ) throws NoServiceFoundException, Exception{
		CLImportedItemsArray clArray = getCodelistImportManagerPortType(scope,securityManager).getImportedCodelists(user);
		if (clArray.getItems() == null) return new ArrayList<CLImportedItem>();
		return Arrays.asList(clArray.getItems());
	}
	
	public static CLImportedItem getItem(String id, String user, GCUBEScope scope, GCUBESecurityManager ... securityManager ) throws NoServiceFoundException, Exception{
		return getCodelistImportManagerPortType(scope,securityManager).getCLImportItem(new CodelistIdentifier(id, user));
	}

	
	public CodelistImportCall(String user, String id, GCUBEScope scope,
			GCUBESecurityManager ...  securityManager) throws NoServiceFoundException, Exception{
		this.user=user;
		this.id = id;
		this.cachedPT= getCodelistImportManagerPortType(scope,securityManager);
	}
	
	public ImportStatusResponse getStatus() throws Exception{
		return cachedPT.getImportStatus(new CodelistIdentifier(id, user));
	}
	
	public String getDataAsJson(Limit limit) throws Exception{
		Exception exception;
		int tries = 0;
		do{
			try{
				return cachedPT.getDataAsJson(new DataAsJsonRequest(new CodelistIdentifier(id, user), limit, null));
			}catch (Exception e) {
				tries++;
				exception=e;
			}
		}while(tries<Constant.MAX_TRIES);
		throw exception;
	}
	
	public List<CodelistColumnDefinition> getColumnsDefinition() throws Exception{
		List<CodelistColumnDefinition> toReturn = new ArrayList<CodelistColumnDefinition>();
		for (CodelistColumnDefinition cdef: cachedPT.getColumnsDefinition(new CodelistIdentifier(id, user)).getDefinition())
			toReturn.add(cdef);
		return toReturn;
			
	}
	
	public void remove() throws Exception{
		cachedPT.remove(new CodelistIdentifier(id, user));
	}

}
