/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.fs;

import java.io.IOException;
import jnr.ffi.Pointer;
import org.gcube.data.access.storagehub.fs.FSInputStream;
import org.gcube.data.access.storagehub.fs.SHFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.struct.FileStat;

public class FileUpload
implements SHFile {
    public static Logger logger = LoggerFactory.getLogger(FileUpload.class);
    FSInputStream stream;
    private int bytesRead = 0;

    public FileUpload(FSInputStream stream) {
        this.stream = stream;
    }

    @Override
    public synchronized int write(Pointer buf, long size, long offset) {
        logger.trace(Thread.currentThread().getName() + " ) calling write " + size + " " + offset);
        if (this.stream == null) {
            return -ErrorCodes.ENOENT();
        }
        byte[] mybuf = new byte[(int)size];
        try {
            buf.get(0L, mybuf, 0, (int)size);
            this.stream.add(mybuf);
        }
        catch (Exception e) {
            logger.error("error on download", (Throwable)e);
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -ErrorCodes.ENOENT();
        }
        this.bytesRead = (int)((long)this.bytesRead + size);
        return (int)size;
    }

    @Override
    public synchronized int flush() {
        try {
            this.stream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return 0;
    }

    @Override
    public int getAttr(FileStat stat) {
        stat.st_mode.set((Number)33133);
        stat.st_size.set((Number)this.bytesRead);
        long now = System.currentTimeMillis() / 1000L;
        stat.st_mtim.tv_sec.set(now);
        stat.st_ctim.tv_sec.set(now);
        stat.st_atim.tv_sec.set(now);
        return 0;
    }

    public boolean uploadFinished() {
        return this.stream.isClosed() && this.stream.available() == 0;
    }
}

