/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.cache2k.Cache;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.spi.CacheLifeCycleListener;
import org.cache2k.jcache.provider.CacheJmxConfiguration;
import org.cache2k.jcache.provider.CacheJmxStatistics;
import org.cache2k.jcache.provider.JCacheAdapter;

public class JCacheJmxSupport
implements CacheLifeCycleListener {
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    @Override
    public void cacheCreated(Cache c, Cache2kConfiguration cfg) {
    }

    @Override
    public void cacheDestroyed(Cache c) {
        this.disableStatistics(c);
        this.disableJmx(c);
    }

    public void enableStatistics(JCacheAdapter c) {
        MBeanServer mbs = this.mBeanServer;
        String _name = this.createStatisticsObjectName(c.cache);
        try {
            mbs.registerMBean(new CacheJmxStatistics(c), new ObjectName(_name));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error registering JMX bean, name='" + _name + "'", e);
        }
    }

    public void disableStatistics(Cache c) {
        MBeanServer mbs = this.mBeanServer;
        String _name = this.createStatisticsObjectName(c);
        try {
            mbs.unregisterMBean(new ObjectName(_name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw new IllegalStateException("Error unregister JMX bean, name='" + _name + "'", e);
        }
    }

    public void enableJmx(Cache c, javax.cache.Cache ca) {
        MBeanServer mbs = this.mBeanServer;
        String _name = this.createJmxObjectName(c);
        try {
            mbs.registerMBean(new CacheJmxConfiguration(ca), new ObjectName(_name));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error register JMX bean, name='" + _name + "'", e);
        }
    }

    public void disableJmx(Cache c) {
        MBeanServer mbs = this.mBeanServer;
        String _name = this.createJmxObjectName(c);
        try {
            mbs.unregisterMBean(new ObjectName(_name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw new IllegalStateException("Error unregister JMX bean, name='" + _name + "'", e);
        }
    }

    public String createStatisticsObjectName(Cache cache) {
        return "javax.cache:type=CacheStatistics,CacheManager=" + JCacheJmxSupport.sanitizeName(cache.getCacheManager().getName()) + ",Cache=" + JCacheJmxSupport.sanitizeName(cache.getName());
    }

    public String createJmxObjectName(Cache cache) {
        return "javax.cache:type=CacheConfiguration,CacheManager=" + JCacheJmxSupport.sanitizeName(cache.getCacheManager().getName()) + ",Cache=" + JCacheJmxSupport.sanitizeName(cache.getName());
    }

    public static String sanitizeName(String string) {
        return string == null ? "" : string.replaceAll(":|=|\n|,", ".");
    }
}

