/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.tests;

import java.util.Collection;
import java.util.ServiceLoader;
import java.util.Set;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueFormatData;
import org.gcube.data.publishing.gCatFeeder.model.InternalConversionException;
import org.gcube.data.publishing.gCatFeeder.tests.InfrastructureTests;
import org.gcube.data.publishing.gCatfeeder.collectors.CollectorPlugin;
import org.gcube.data.publishing.gCatfeeder.collectors.model.PluginDescriptor;
import org.gcube.data.publishing.gCatfeeder.collectors.model.faults.CatalogueNotSupportedException;
import org.gcube.data.publishing.gCatfeeder.collectors.model.faults.CollectorFault;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCollectorTest
extends InfrastructureTests {
    private static final Logger log = LoggerFactory.getLogger(BaseCollectorTest.class);
    private static ServiceLoader<CollectorPlugin> collectorPluginsLoader = ServiceLoader.load(CollectorPlugin.class);

    @BeforeClass
    public static void checkPluginRegistration() {
        int pluginsCounter = 0;
        for (CollectorPlugin pl : collectorPluginsLoader) {
            ++pluginsCounter;
        }
        Assert.assertFalse((String)"No plugin is actually registered ", (pluginsCounter == 0 ? 1 : 0) != 0);
        for (CollectorPlugin plugin : collectorPluginsLoader) {
            PluginDescriptor desc = plugin.getDescriptor();
            plugin.setEnvironmentConfiguration(BaseCollectorTest.getEnvironmentConfiguration());
            Assert.assertNotNull((String)(plugin.getClass() + " No Descriptor exposed"), (Object)desc);
            try {
                plugin.init();
            }
            catch (Throwable t) {
                log.error("", t);
                Assert.fail((String)("Unable to init plugin " + desc.getName()));
            }
            Assert.assertTrue((String)(String.valueOf(desc.getName()) + ": No catalogues supported"), (plugin.getSupportedCatalogueTypes().size() > 0 ? 1 : 0) != 0);
            for (String supportedCatalogue : plugin.getSupportedCatalogueTypes()) {
                try {
                    Assert.assertNotNull((String)(String.valueOf(desc.getName()) + ": Null configuration for exposed " + supportedCatalogue), (Object)plugin.getPublisherControllerConfiguration(supportedCatalogue));
                    Assert.assertNotNull((String)(String.valueOf(desc.getName()) + ": Null retriever for exposed " + supportedCatalogue), (Object)plugin.getRetrieverByCatalogueType(supportedCatalogue));
                    Assert.assertNotNull((String)(String.valueOf(desc.getName()) + ": Null transformer for exposed " + supportedCatalogue), (Object)plugin.getTransformerByCatalogueType(supportedCatalogue));
                }
                catch (CatalogueNotSupportedException e) {
                    log.error("", (Throwable)e);
                    Assert.fail((String)("Exposed supported catalogue actually not covered." + e.getMessage()));
                }
            }
            Assert.assertNotNull((String)(String.valueOf(desc.getName()) + ": No actual collector "), (Object)plugin.getCollector());
        }
        if (BaseCollectorTest.isTestInfrastructureEnabled()) {
            for (CollectorPlugin plugin : collectorPluginsLoader) {
                try {
                    plugin.setEnvironmentConfiguration(BaseCollectorTest.getEnvironmentConfiguration());
                    Set collected = plugin.getCollector().collect();
                    for (String catalogue : plugin.getSupportedCatalogueTypes()) {
                        log.debug("Simulating publication towards {} ", (Object)catalogue);
                        Set transformed = plugin.getTransformerByCatalogueType(catalogue).transform((Collection)collected);
                        log.debug("Transformed size = {} ");
                        for (CatalogueFormatData f : transformed) {
                            log.debug(f.toCatalogueFormat());
                        }
                    }
                }
                catch (CollectorFault e) {
                    log.error("", (Throwable)e);
                    Assert.fail((String)("Infrastructure Environment not suitable for testing" + e.getMessage()));
                }
                catch (CatalogueNotSupportedException e) {
                    log.error("", (Throwable)e);
                    Assert.fail((String)("Exception while getting transformer in scope : " + e.getMessage()));
                }
                catch (InternalConversionException e) {
                    log.error("", (Throwable)e);
                    Assert.fail((String)("Failed internatl conversion : " + e.getMessage()));
                }
            }
        }
    }
}

