/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.engine.impl;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.gcube.data.publishing.gCatFeeder.catalogues.CataloguePlugin;
import org.gcube.data.publishing.gCatFeeder.service.engine.CatalogueControllersManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.Infrastructure;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.CataloguePluginNotFound;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.InternalError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogueControllersManagerImpl
implements CatalogueControllersManager {
    private static final Logger log = LoggerFactory.getLogger(CatalogueControllersManagerImpl.class);
    private ServiceLoader<CataloguePlugin> cataloguePluginsLoader = null;
    private ConcurrentHashMap<String, CataloguePlugin> availablePlugins = new ConcurrentHashMap();
    @Inject
    private Infrastructure infrastructure;

    @PostConstruct
    public void post() {
        log.debug("Loading catalogue plugins...");
        this.cataloguePluginsLoader = ServiceLoader.load(CataloguePlugin.class);
        for (CataloguePlugin cataloguePlugin : this.cataloguePluginsLoader) {
            log.debug("Loading {} ", cataloguePlugin.getClass());
            log.debug("Descriptor {} ", (Object)cataloguePlugin.getDescriptor());
            this.availablePlugins.put(cataloguePlugin.getDescriptor().getId(), cataloguePlugin);
        }
        log.trace("Loaded {} catalogue plugins ", (Object)this.availablePlugins.size());
        log.trace("Static initialization...");
        for (Map.Entry entry : this.availablePlugins.entrySet()) {
            log.debug("Static initialization for : {} ", entry.getKey());
            try {
                ((CataloguePlugin)entry.getValue()).init();
            }
            catch (Throwable t) {
                log.error("Unexpected exception while initializing {} ", entry.getKey(), (Object)t);
            }
        }
    }

    public Set<String> getAvailableControllers() {
        return this.availablePlugins.keySet();
    }

    public CataloguePlugin getPluginById(String pluginId) throws CataloguePluginNotFound {
        if (this.availablePlugins.containsKey(pluginId)) {
            return (CataloguePlugin)this.availablePlugins.get(pluginId);
        }
        throw new CataloguePluginNotFound("Catalogue plugin " + pluginId + " not available.");
    }

    public void initInScope() throws InternalError {
        log.trace("Initialization under scope {} ", (Object)this.infrastructure.getCurrentContext());
        for (Map.Entry entry : this.availablePlugins.entrySet()) {
            log.debug("Scope initialization for : {} ", entry.getKey());
            try {
                ((CataloguePlugin)entry.getValue()).initInScope();
            }
            catch (Throwable t) {
                log.error("Unexpected exception while initializing {} ", entry.getKey(), (Object)t);
            }
        }
    }
}

