/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.rest;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.CataloguePluginDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.GCatFeederManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.CatalogueControllersManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.CollectorsManager;
import org.gcube.data.publishing.gCatFeeder.service.rest.Capabilities;
import org.gcube.data.publishing.gCatfeeder.collectors.model.PluginDescriptor;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=GCatFeederManager.class)
@Path(value="capabilities")
public class Capabilities {
    private static final Logger log = LoggerFactory.getLogger(Capabilities.class);
    @Inject
    private CatalogueControllersManager catalogues;
    @Inject
    private CollectorsManager collectors;

    @GET
    @Produces(value={"application/json"})
    @Path(value="harvesters")
    public Response getCollectorCapabilities() {
        try {
            ArrayList<PluginDescriptor> toReturn = new ArrayList<PluginDescriptor>();
            for (String s : this.collectors.getAvailableCollectors()) {
                toReturn.add(this.collectors.getPluginById(s).getDescriptor());
            }
            1 entity = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)entity).build();
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception ", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="controllers")
    public Response getCataloguesCapabilities() {
        try {
            ArrayList<CataloguePluginDescriptor> toReturn = new ArrayList<CataloguePluginDescriptor>();
            for (String s : this.catalogues.getAvailableControllers()) {
                toReturn.add(this.catalogues.getPluginById(s).getDescriptor());
            }
            2 entity = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)entity).build();
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception ", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

