/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.gcube.data.publishing.gCatFeeder.service.engine.ConnectionManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.Infrastructure;
import org.gcube.data.publishing.gCatFeeder.service.engine.LocalConfiguration;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.DatabaseConnectionDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.Queries;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.InternalError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerImpl
implements ConnectionManager {
    private static final Logger log;
    private ConcurrentHashMap<String, DataSource> datasources = new ConcurrentHashMap();
    private ConcurrentHashMap<String, DatabaseConnectionDescriptor> databases = new ConcurrentHashMap();
    @Inject
    private Infrastructure infrastructure;
    @Inject
    private LocalConfiguration configuration;

    private synchronized DatabaseConnectionDescriptor getDB() throws InternalError {
        if (!this.databases.containsKey(this.infrastructure.getCurrentContext())) {
            this.databases.put(this.infrastructure.getCurrentContext(), this.infrastructure.queryForDatabase(this.configuration.getProperty("db.ep.category"), this.configuration.getProperty("db.ep.name")));
        }
        return (DatabaseConnectionDescriptor)this.databases.get(this.infrastructure.getCurrentContext());
    }

    public Connection getConnection() throws SQLException, InternalError {
        log.debug("Getting DB connection in {} ", (Object)this.infrastructure.getCurrentContext());
        DataSource ds = this.getDataSource();
        Connection conn = ds.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    private synchronized DataSource getDataSource() throws InternalError, SQLException {
        DatabaseConnectionDescriptor dbDescriptor = this.getDB();
        if (!this.datasources.containsKey(dbDescriptor.getUrl())) {
            this.datasources.put(dbDescriptor.getUrl(), this.setupDataSource(dbDescriptor));
        }
        return (DataSource)this.datasources.get(dbDescriptor.getUrl());
    }

    private DataSource setupDataSource(DatabaseConnectionDescriptor db) throws SQLException, InternalError {
        log.trace("Setting up data source for {} ", (Object)db);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(Integer.parseInt(this.configuration.getProperty("db.pools.max_idle")));
        poolConfig.setMaxTotal(Integer.parseInt(this.configuration.getProperty("db.pools.max_total")));
        poolConfig.setMinIdle(Integer.parseInt(this.configuration.getProperty("db.pools.min_total")));
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(db.getUrl(), db.getUsername(), db.getPassword());
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        log.trace("Initializing schema...");
        try (Connection conn = null;){
            conn = dataSource.getConnection();
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate(Queries.getInitDB((DatabaseConnectionDescriptor.Flavor)db.getFlavor()));
        }
        return dataSource;
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("PERFORM SERVICE - UNABLE TO REGISTER postgresql DRIVER");
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        log = LoggerFactory.getLogger(ConnectionManagerImpl.class);
    }
}

