/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gFeed.collectors.oai;

import java.beans.ConstructorProperties;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import lombok.NonNull;
import org.gcube.data.publishing.gFeed.collectors.oai.model.CommunicationException;
import org.gcube.data.publishing.gFeed.collectors.oai.model.DCRecordMetadata;
import org.gcube.data.publishing.gFeed.collectors.oai.model.MetadataHolder;
import org.gcube.data.publishing.gFeed.collectors.oai.model.OAIInteractionException;
import org.gcube.data.publishing.gFeed.collectors.oai.model.OAIMetadata;
import org.gcube.data.publishing.gFeed.collectors.oai.model.OAIRecord;
import org.gcube.data.publishing.gFeed.collectors.oai.model.OAI_PMH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIClient {
    private static final Logger log = LoggerFactory.getLogger(OAIClient.class);
    private static JAXBContext jaxbContext = null;
    private static final int MAX_ATTEMPTS = 3;
    private static final long DELAY_FACTOR = 1000L;
    public static final String DC_METADATA_PREFIX = "oai_dc";
    @NonNull
    private String baseUrl;
    @NonNull
    private Integer maxItems = -1;
    Client client;
    private List<String> specifiedSets = new ArrayList<String>();

    private static synchronized JAXBContext getContext() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OAIRecord.class, MetadataHolder.class, OAIMetadata.class, DCRecordMetadata.class, OAI_PMH.class});
        }
        return jaxbContext;
    }

    private synchronized Client getWebClient() {
        if (this.client == null) {
            this.client = (Client)ClientBuilder.newClient().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        }
        return this.client;
    }

    public Collection<OAIRecord> getAll(String metadataPrefix) throws JAXBException, OAIInteractionException {
        ArrayList<OAIRecord> toReturn = new ArrayList<OAIRecord>();
        WebTarget target = this.getWebClient().target(this.baseUrl).queryParam("verb", new Object[]{"ListRecords"});
        if (!this.specifiedSets.isEmpty()) {
            for (String set : this.specifiedSets) {
                log.info("Loading " + metadataPrefix + " SET : " + set + " from " + this.baseUrl);
                target.queryParam("set", new Object[]{set});
                toReturn.addAll(this.call(target, metadataPrefix));
            }
        } else {
            log.info("Loading " + metadataPrefix + " from " + this.baseUrl);
            toReturn.addAll(this.call(target, metadataPrefix));
        }
        log.info("Obtained " + toReturn.size() + " from " + this.baseUrl);
        return toReturn;
    }

    private List<OAIRecord> call(WebTarget target, String metadataPrefix) {
        ArrayList<OAIRecord> toReturn = new ArrayList<OAIRecord>();
        String resumptionToken = null;
        boolean isComplete = false;
        int currentAttempt = 1;
        while (!isComplete) {
            try {
                target = resumptionToken == null ? target.queryParam("metadataPrefix", new Object[]{metadataPrefix}) : target.queryParam("resumptionToken", new Object[]{resumptionToken});
                Response resp = target.request(new String[]{"application/xml"}).get();
                OAI_PMH msg = OAIClient.check(resp);
                if (msg.isError()) {
                    throw new OAIInteractionException(msg.getError().getCode() + " : " + msg.getError().getMessage());
                }
                currentAttempt = 1;
                toReturn.addAll(msg.getResponseRecords().getRecords());
                log.debug("Parsed " + toReturn.size() + " records so far.");
                OAI_PMH.Token t = msg.getResponseRecords().getResumptionToken();
                log.debug("Obtained token : " + t);
                if (t != null && t.getId() != null && !t.getId().isEmpty()) {
                    resumptionToken = t.getId();
                } else {
                    isComplete = true;
                }
                if (this.maxItems <= 0 || toReturn.size() < this.maxItems) continue;
                log.warn("MAX ITEMS LIMIT REACHED : " + toReturn.size() + " / " + this.maxItems);
                isComplete = true;
            }
            catch (Throwable t) {
                log.warn("Unexpected ERROR\t " + t.getMessage());
                log.debug("Current attempt number = " + currentAttempt, (Object)" max attempt Number = 3, attempts delay factor =  ");
                isComplete = currentAttempt > 3;
                try {
                    Thread.sleep((long)currentAttempt * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++currentAttempt;
            }
        }
        return toReturn;
    }

    private static OAI_PMH check(Response resp) throws JAXBException, CommunicationException {
        if (resp.getStatus() < 200 || resp.getStatus() >= 300) {
            throw new CommunicationException("Received error message. STATUS " + resp.getStatus() + ", message : " + (String)resp.readEntity(String.class));
        }
        String respString = (String)resp.readEntity(String.class);
        Unmarshaller jaxbUnmarshaller = OAIClient.getContext().createUnmarshaller();
        OAI_PMH obj = (OAI_PMH)jaxbUnmarshaller.unmarshal((Reader)new StringReader(respString));
        return obj;
    }

    @ConstructorProperties(value={"baseUrl"})
    public OAIClient(@NonNull String baseUrl) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl");
        }
        this.baseUrl = baseUrl;
    }

    public void setMaxItems(@NonNull Integer maxItems) {
        if (maxItems == null) {
            throw new NullPointerException("maxItems");
        }
        this.maxItems = maxItems;
    }

    public List<String> getSpecifiedSets() {
        return this.specifiedSets;
    }
}

