/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PUT;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.gcat.annotation.PURGE;
import org.gcube.gcat.oldutils.Validator;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.persistence.ckan.CKANOrganization;
import org.gcube.gcat.persistence.ckan.CKANResource;
import org.gcube.gcat.persistence.ckan.CKANUtility;
import org.gcube.gcat.profile.MetadataUtility;
import org.gcube.gcat.social.SocialService;
import org.gcube.gcat.utils.ContextUtility;
import org.gcube.gcat.utils.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CKANPackage
extends CKAN {
    private static final Logger logger = LoggerFactory.getLogger(CKANPackage.class);
    public static final String ITEM_LIST = "/api/3/action/package_search";
    public static final String ITEM_CREATE = "/api/3/action/package_create";
    public static final String ITEM_SHOW = "/api/3/action/package_show";
    public static final String ITEM_UPDATE = "/api/3/action/package_update";
    public static final String ITEM_PATCH = "/api/3/action/package_patch";
    public static final String ITEM_DELETE = "/api/3/action/package_delete";
    public static final String ITEM_PURGE = "/api/3/action/dataset_purge";
    protected static final String ROWS_KEY = "rows";
    protected static final String START_KEY = "start";
    protected static final String Q_KEY = "q";
    protected static final String ORGANIZATION_FILTER_TEMPLATE = "organization:%s";
    protected static final String LICENSE_KEY = "license_id";
    protected static final String EXTRAS_ITEM_URL_KEY = "Item URL";
    protected static final String AUTHOR_KEY = "author";
    protected static final String AUTHOR_EMAIL_KEY = "author_email";
    protected static final String OWNER_ORG_KEY = "owner_org";
    protected static final String RESOURCES_KEY = "resources";
    protected static final String TITLE_KEY = "title";
    public static final String EXTRAS_KEY = "extras";
    public static final String EXTRAS_KEY_KEY = "key";
    public static final String EXTRAS_KEY_VALUE_SYSTEM_TYPE = "system:type";
    public static final String EXTRAS_VALUE_KEY = "value";
    private static final String RESULTS_KEY = "results";
    protected static final String PRIVATE_KEY = "private";
    protected static final String SEARCHABLE_KEY = "searchable";
    public static final String GROUPS_KEY = "groups";
    public static final String TAGS_KEY = "tags";
    protected final List<CKANResource> managedResources;
    protected String itemID;

    public CKANPackage() {
        this.LIST = ITEM_LIST;
        this.CREATE = ITEM_CREATE;
        this.READ = ITEM_SHOW;
        this.UPDATE = ITEM_UPDATE;
        this.PATCH = ITEM_PATCH;
        this.DELETE = ITEM_DELETE;
        this.PURGE = ITEM_PURGE;
        this.managedResources = new ArrayList();
    }

    protected String getOrganizationName(ScopeBean scopeBean) {
        String contextName = scopeBean.name();
        return contextName.toLowerCase().replace(" ", "_");
    }

    protected String getOrganizationName() {
        ScopeBean scopeBean = new ScopeBean(ContextUtility.getCurrentContext());
        return this.getOrganizationName(scopeBean);
    }

    public ObjectNode checkBaseInformation(String json) throws Exception {
        boolean privatePackage;
        ObjectNode objectNode = (ObjectNode)this.mapper.readTree(json);
        if ((objectNode = (ObjectNode)this.checkName((JsonNode)objectNode)).has("id")) {
            this.itemID = objectNode.get("id").asText();
        }
        if (objectNode.has(PRIVATE_KEY) && (privatePackage = objectNode.get(PRIVATE_KEY).asBoolean())) {
            objectNode.put(SEARCHABLE_KEY, true);
        }
        String licenseId = null;
        if (objectNode.has(LICENSE_KEY)) {
            licenseId = objectNode.get(LICENSE_KEY).asText();
        }
        if (licenseId == null || licenseId.isEmpty()) {
            throw new BadRequestException("You must specify a license identifier for the item. License list can be retrieved using licence collection");
        }
        JsonNode userJsonNode = CKANUtility.getCKANUser();
        objectNode.put(AUTHOR_KEY, userJsonNode.get("name").asText());
        objectNode.put(AUTHOR_EMAIL_KEY, userJsonNode.get("email").asText());
        ScopeBean scopeBean = new ScopeBean(ContextUtility.getCurrentContext());
        String gotOrganization = null;
        if (objectNode.has(OWNER_ORG_KEY)) {
            gotOrganization = objectNode.get(OWNER_ORG_KEY).asText();
        }
        if (scopeBean.is(ScopeBean.Type.VRE)) {
            String organizationFromContext = this.getOrganizationName(scopeBean);
            if (gotOrganization != null) {
                if (gotOrganization.compareTo(organizationFromContext) != 0) {
                    CKANOrganization ckanOrganization = new CKANOrganization();
                    ckanOrganization.setName(organizationFromContext);
                    ckanOrganization.read();
                    String organizationID = null;
                    if (ckanOrganization.result.has("id")) {
                        organizationID = ckanOrganization.result.get("id").asText();
                    }
                    if (organizationID == null || gotOrganization.compareTo(organizationID) != 0) {
                        throw new BadRequestException("You can only publish in the Organization associate to the current VRE");
                    }
                }
            } else {
                objectNode.put(OWNER_ORG_KEY, organizationFromContext);
            }
        } else if (gotOrganization == null) {
            throw new BadRequestException("You must specify an Organization usign owner_org field");
        }
        return objectNode;
    }

    protected JsonNode validateJson(String json) {
        try {
            ObjectNode objectNode = this.checkBaseInformation(json);
            MetadataUtility metadataUtility = MetadataUtility.getInstance();
            if (!metadataUtility.getMetadataProfiles().isEmpty()) {
                Validator validator = new Validator(this.mapper);
                objectNode = validator.validateAgainstProfile(objectNode);
            }
            return objectNode;
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    public String list(int limit, int offset) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (limit <= 0) {
            limit = 1000;
        }
        parameters.put(ROWS_KEY, String.valueOf(limit));
        if (offset < 0) {
            offset = 0;
        }
        parameters.put(START_KEY, String.valueOf(offset * limit));
        String organizationName = this.getOrganizationName();
        String organizationQueryString = String.format(ORGANIZATION_FILTER_TEMPLATE, organizationName);
        parameters.put(Q_KEY, organizationQueryString);
        this.sendGetRequest(this.LIST, parameters);
        ArrayNode results = (ArrayNode)this.result.get(RESULTS_KEY);
        ArrayNode arrayNode = this.mapper.createArrayNode();
        for (JsonNode node : results) {
            try {
                String name = node.get("name").asText();
                arrayNode.add(name);
            }
            catch (Exception e) {
                try {
                    logger.error("Unable to get the ID of {}. the result will not be included in the result", (Object)this.mapper.writeValueAsString((Object)node));
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                }
            }
        }
        return this.getAsString((JsonNode)arrayNode);
    }

    protected void rollbackManagedResources() {
        for (CKANResource ckanResource : this.managedResources) {
            try {
                ckanResource.rollback();
            }
            catch (Exception e) {
                logger.error("Unable to rollback resource {} to the original value", (Object)ckanResource.getResourceID());
            }
        }
    }

    protected ArrayNode createResources(ArrayNode resourcesToBeCreated) {
        ArrayNode created = this.mapper.createArrayNode();
        for (JsonNode resourceNode : resourcesToBeCreated) {
            CKANResource ckanResource = new CKANResource(this.itemID);
            String json = ckanResource.create(this.getAsString(resourceNode));
            created.add(this.getAsJsonNode(json));
            this.managedResources.add(ckanResource);
        }
        return created;
    }

    protected JsonNode addExtraField(JsonNode jsonNode, String key, String value) {
        ArrayNode extras = null;
        boolean found = false;
        if (jsonNode.has(EXTRAS_KEY)) {
            extras = (ArrayNode)jsonNode.get(EXTRAS_KEY);
            for (JsonNode extra : extras) {
                if (!extra.has(EXTRAS_KEY_KEY) || extra.get(EXTRAS_KEY_KEY).asText().compareTo(key) != 0) continue;
                ((ObjectNode)extra).put(EXTRAS_VALUE_KEY, value);
                found = true;
                break;
            }
        } else {
            extras = this.mapper.createArrayNode();
        }
        if (!found) {
            ObjectNode extra = this.mapper.createObjectNode();
            extra.put(EXTRAS_KEY_KEY, key);
            extra.put(EXTRAS_VALUE_KEY, value);
            extras.add((JsonNode)extra);
        }
        return jsonNode;
    }

    protected String addItemURLViaResolver(JsonNode jsonNode) {
        URIResolver uriResolver = new URIResolver();
        String catalogueItemURL = uriResolver.getCatalogueItemURL(this.name);
        this.addExtraField(jsonNode, EXTRAS_ITEM_URL_KEY, catalogueItemURL);
        return catalogueItemURL;
    }

    public String create(String json) {
        try {
            logger.debug("Going to create Item {}", (Object)json);
            JsonNode jsonNode = this.validateJson(json);
            ArrayNode resourcesToBeCreated = this.mapper.createArrayNode();
            if (jsonNode.has(RESOURCES_KEY)) {
                resourcesToBeCreated = (ArrayNode)jsonNode.get(RESOURCES_KEY);
                ((ObjectNode)jsonNode).remove(RESOURCES_KEY);
            }
            String catalogueItemURL = this.addItemURLViaResolver(jsonNode);
            super.create(this.getAsString(jsonNode));
            this.itemID = this.result.get("id").asText();
            ArrayNode created = this.createResources(resourcesToBeCreated);
            ((ObjectNode)this.result).replace(RESOURCES_KEY, (JsonNode)created);
            String title = this.result.get(TITLE_KEY).asText();
            ArrayNode arrayNode = (ArrayNode)this.result.get(TAGS_KEY);
            SocialService packagePostActions = new SocialService(catalogueItemURL, this.name, arrayNode, title);
            packagePostActions.start();
            return this.getAsString(this.result);
        }
        catch (WebApplicationException e) {
            this.rollbackManagedResources();
            throw e;
        }
        catch (Exception e) {
            this.rollbackManagedResources();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public String update(String json) {
        try {
            Object ckanResource;
            JsonNode jsonNode = this.validateJson(json);
            this.itemID = jsonNode.get("id").asText();
            this.read();
            HashMap<String, Object> originalResources = new HashMap<String, Object>();
            ArrayNode originalResourcesarrayNode = (ArrayNode)this.result.get(RESOURCES_KEY);
            if (originalResources != null) {
                for (JsonNode resourceNode : originalResourcesarrayNode) {
                    ckanResource = new CKANResource(this.itemID);
                    ckanResource.setPreviousRepresentation(resourceNode);
                    String resourceID = ckanResource.getResourceID();
                    originalResources.put(resourceID, ckanResource);
                }
            }
            if (jsonNode.has(RESOURCES_KEY)) {
                ArrayNode resourcesToBeSend = this.mapper.createArrayNode();
                ArrayNode receivedResources = (ArrayNode)jsonNode.get(RESOURCES_KEY);
                for (JsonNode resourceNode : receivedResources) {
                    CKANResource ckanResource2 = new CKANResource(this.itemID);
                    String resourceId = CKANResource.extractResourceID((JsonNode)resourceNode);
                    if (resourceId != null) {
                        if (originalResources.containsKey(resourceId)) {
                            ckanResource2 = (CKANResource)originalResources.get(resourceId);
                            originalResources.remove(resourceId);
                        } else {
                            throw new BadRequestException("The content cotains a resource with id " + resourceId + " which does not exists");
                        }
                    }
                    resourceNode = ckanResource2.createOrUpdate(resourceNode);
                    resourcesToBeSend.add(resourceNode);
                    this.managedResources.add(ckanResource2);
                }
                ((ObjectNode)jsonNode).replace(RESOURCES_KEY, (JsonNode)resourcesToBeSend);
            }
            this.addItemURLViaResolver(jsonNode);
            this.sendPostRequest(ITEM_UPDATE, this.getAsString(jsonNode));
            for (String resourceId : originalResources.keySet()) {
                ckanResource = (CKANResource)originalResources.get(resourceId);
                ckanResource.deleteFile();
            }
            return this.getAsString(this.result);
        }
        catch (WebApplicationException e) {
            this.rollbackManagedResources();
            throw e;
        }
        catch (Exception e) {
            this.rollbackManagedResources();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public String patch(String json) {
        String[] moreAllowed = new String[]{HEAD.class.getSimpleName(), GET.class.getSimpleName(), PUT.class.getSimpleName(), DELETE.class.getSimpleName(), PURGE.class.getSimpleName()};
        throw new NotAllowedException(OPTIONS.class.getSimpleName(), moreAllowed);
    }

    protected void delete() {
        super.delete();
    }

    public void purge() {
        block4: {
            try {
                this.delete();
            }
            catch (WebApplicationException e) {
                Response.Status status = Response.Status.fromStatusCode((int)e.getResponse().getStatusInfo().getStatusCode());
                if (status == Response.Status.NOT_FOUND) break block4;
                throw e;
            }
        }
        this.setApiKey(CKANUtility.getSysAdminAPI());
        this.read();
        if (this.result.has(RESOURCES_KEY)) {
            this.itemID = this.result.get("id").asText();
            ArrayNode arrayNode = (ArrayNode)this.result.get(RESOURCES_KEY);
            for (JsonNode jsonNode : arrayNode) {
                CKANResource ckanResource = new CKANResource(this.itemID);
                ckanResource.setPreviousRepresentation(jsonNode);
                ckanResource.deleteFile();
            }
        }
        super.purge();
    }
}

