/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.profile;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.datacatalogue.metadatadiscovery.reader.QueryForResourceUtil;
import org.gcube.gcat.profile.MetadataUtility;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISProfile {
    public static int PRETTY_PRINT_INDENT_FACTOR = 4;
    private static Logger logger = LoggerFactory.getLogger(ISProfile.class);
    protected ObjectMapper mapper = new ObjectMapper();

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public ArrayNode list() {
        ArrayNode arrayNode = this.mapper.createArrayNode();
        try {
            Set names = MetadataUtility.getInstance().getProfilesNames();
            for (String name : names) {
                arrayNode.add(name);
            }
            return arrayNode;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected GenericResource instantiateGenericResource(String name, String xml) throws Exception {
        GenericResource genericResource = new GenericResource();
        GenericResource.Profile profile = genericResource.newProfile();
        profile.type("DataCatalogueMetadata");
        profile.name(name);
        profile.description("Profile create using gCat");
        profile.newBody(xml);
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)genericResource, (Writer)stringWriter);
        logger.debug("The generated {} is\n{}", (Object)GenericResource.class.getSimpleName(), (Object)stringWriter.toString());
        return genericResource;
    }

    protected void createGenericResource(String name, String xml) throws Exception {
        GenericResource genericResource = this.instantiateGenericResource(name, xml);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        genericResource = (GenericResource)registryPublisher.create((Resource)genericResource);
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)genericResource, (Writer)stringWriter);
        logger.trace("The {} with ID {} has been created \n{}", new Object[]{GenericResource.class.getSimpleName(), genericResource.id(), stringWriter.toString()});
    }

    protected GenericResource getGenericResource(String name) {
        String query = QueryForResourceUtil.getGcubeGenericQueryStringForSecondaryTypeAndName((String)name, (String)"DataCatalogueMetadata");
        QueryBox q = new QueryBox(query);
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List resources = client.submit((Query)q);
        if (resources == null || resources.size() == 0) {
            throw new InternalServerErrorException("No Resources with secondaryType 'DataCatalogueMetadata' and name '" + name + "' exists in the current context");
        }
        if (resources.size() == 1) {
            GenericResource genericResource = (GenericResource)resources.get(0);
            return genericResource;
        }
        throw new InternalServerErrorException("More than one Resource with secondaryType 'DataCatalogueMetadata' and name '" + name + "' exists in the current context");
    }

    protected void updateGenericResource(String name, String xml) {
        GenericResource genericResource = this.getGenericResource(name);
        logger.info("The {} with ID {} is going to be updated", (Object)GenericResource.class.getSimpleName(), (Object)genericResource.id());
        genericResource.profile().newBody(xml);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        registryPublisher.update((Resource)genericResource);
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)genericResource, (Writer)stringWriter);
        logger.trace("The {} with ID {} has been updated to \n{}", new Object[]{GenericResource.class.getSimpleName(), genericResource.id(), stringWriter.toString()});
    }

    protected void removeGenericResource(String name) {
        GenericResource genericResource = this.getGenericResource(name);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        registryPublisher.remove((Resource)genericResource);
    }

    public String read(String name, boolean xml) {
        try {
            String profile = MetadataUtility.getInstance().getMetadataFormat(name).getMetadataSource();
            if (profile != null) {
                if (xml) {
                    return profile;
                }
                JSONObject xmlJSONObj = XML.toJSONObject((String)profile);
                String jsonString = xmlJSONObj.toString(PRETTY_PRINT_INDENT_FACTOR);
                return jsonString;
            }
            throw new NotFoundException("Profile with name " + name + " not found");
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }

    public boolean createOrUpdate(String name, String xml) {
        try {
            MetadataUtility metadataUtility = MetadataUtility.getInstance();
            metadataUtility.getDataCalogueMetadataFormatReader().validateProfile(xml);
            if (metadataUtility.getMetadataFormat(name) == null) {
                this.createGenericResource(name, xml);
                boolean bl = true;
                return bl;
            }
            this.updateGenericResource(name, xml);
            boolean bl = false;
            return bl;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
        finally {
            MetadataUtility.clearCache();
        }
    }

    public boolean delete(String name) {
        try {
            MetadataUtility metadataUtility = MetadataUtility.getInstance();
            if (metadataUtility.getMetadataFormat(name) == null) {
                throw new NotFoundException("Profile with name " + name + " not found");
            }
            this.removeGenericResource(name);
            boolean bl = true;
            return bl;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
        finally {
            MetadataUtility.clearCache();
        }
    }
}

