/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogue;
import org.gcube.datacatalogue.ckanutillibrary.server.utils.url.EntityContext;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.utils.ContextUtility;

public class URIResolver {
    private static final String CATALOGUE_CONTEXT = "gcube_scope";
    private static final String ENTITY_TYPE = "entity_context";
    private static final String ENTITY_NAME = "entity_name";
    private static final String CATALOGUE_PLAIN_URL = "clear_url";
    protected ObjectMapper mapper = new ObjectMapper();

    protected StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    public String getCatalogueItemURL(String name) {
        try {
            DataCatalogue dataCatalogue = CKAN.getCatalogue();
            String uriResolverURL = dataCatalogue.getUriResolverUrl();
            ObjectNode requestContent = this.mapper.createObjectNode();
            requestContent.put(CATALOGUE_CONTEXT, ContextUtility.getCurrentContext());
            requestContent.put(ENTITY_TYPE, EntityContext.PRODUCT.toString());
            requestContent.put(ENTITY_NAME, name);
            requestContent.put(CATALOGUE_PLAIN_URL, String.valueOf(true));
            GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)uriResolverURL);
            gxhttpStringRequest.from("gCat");
            gxhttpStringRequest.isExternalCall(true);
            String body = this.mapper.writeValueAsString((Object)requestContent);
            HttpURLConnection httpURLConnection = gxhttpStringRequest.post(body);
            if (httpURLConnection.getResponseCode() != 200) {
                throw new InternalServerErrorException("Unable to get Item URL via URI Resolver");
            }
            String url = this.getStringBuilder(httpURLConnection.getInputStream()).toString();
            return url;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

