/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.grs2;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.FileFieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.FieldNaming;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.Unary;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.contenttype.ContentTypeEvaluator;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRS2Aggregator
extends Unary
implements Runnable {
    private static Logger log = LoggerFactory.getLogger((String)GRS2Aggregator.class.getName());
    private File sinkFile;
    private IRecordWriter<Record> writer;
    FieldDefinition[] wfdefs;
    private String delimiter = Character.toString('\u0001');
    private IRecordReader<Record> reader = null;
    private String filterMask;
    private RecordDefinition[] fieldDefs;

    public GRS2Aggregator(URI inLocator, Map<String, String> parameters, StatsContainer statsCont, long timeout, TimeUnit timeUnit) throws Exception {
        super(inLocator, parameters, statsCont, timeout, timeUnit);
    }

    public GRS2Aggregator(URI inLocator, Map<String, String> parameters, StatsContainer statsCont) throws Exception {
        super(inLocator, parameters, statsCont);
        if (parameters != null && parameters.get("delimiter") != null) {
            this.delimiter = Character.toString(parameters.get("delimiter").charAt(0));
        }
    }

    public URI compute() throws Exception {
        this.reader = new ForwardReader(this.inLocator);
        this.fieldDefs = this.reader.getRecordDefinitions();
        this.wfdefs = this.initializeSchema();
        this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(this.wfdefs)}, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        this.sinkFile = File.createTempFile("grs2DS", ".tmp");
        new Thread(this).start();
        return this.writer.getLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rc;
        long firstOutputStop;
        long firstInputStop;
        long start;
        block42: {
            firstInputStop = start = Calendar.getInstance().getTimeInMillis();
            firstOutputStop = start;
            rc = 0;
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(this.sinkFile, true));
                while (true) {
                    try {
                        while (this.reader.getStatus() != IBuffer.Status.Dispose) {
                            if (this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                                break block42;
                            }
                            Record rec = this.reader.get(this.timeout, this.timeUnit);
                            if (rec == null) {
                                if (this.reader.getStatus() == IBuffer.Status.Open) {
                                    log.warn("Producer has timed out");
                                }
                                break block42;
                            }
                            if (rc == 0) {
                                firstInputStop = Calendar.getInstance().getTimeInMillis();
                            }
                            for (int i = 0; i < rec.getFields().length; ++i) {
                                Field field = rec.getField(i);
                                if (!(field instanceof StringField)) continue;
                                bw.write(((StringField)field).getPayload());
                                if (i == rec.getFields().length - 1) continue;
                                bw.write(this.delimiter);
                            }
                            bw.newLine();
                            log.trace("Trying to persist to file " + this.sinkFile + "#" + rc);
                            ++rc;
                        }
                    }
                    catch (Exception e) {
                        log.error("Could not retrieve and store the record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("Error during source retrieval. Closing", (Throwable)e);
            }
            finally {
                try {
                    bw.close();
                    this.reader.close();
                }
                catch (Exception ee) {}
            }
        }
        ArrayList<Object> fieldList = new ArrayList<Object>();
        block36: for (FieldDefinition field : this.wfdefs) {
            switch (FieldNaming.LocalFieldName.valueOf(field.getName())) {
                case id: {
                    fieldList.add(new StringField(this.sinkFile.getName()));
                    continue block36;
                }
                case bytestream: {
                    fieldList.add(new FileField(this.sinkFile));
                    continue block36;
                }
                case mimeType: {
                    fieldList.add(new StringField(ContentTypeEvaluator.getContentType(this.sinkFile)));
                    continue block36;
                }
                default: {
                    log.warn("Unexpected field: " + field.getName());
                }
            }
        }
        GenericRecord rec = new GenericRecord();
        rec.setFields(fieldList.toArray(new Field[fieldList.size()]));
        log.debug("Returning next row with id: " + this.sinkFile);
        while (true) {
            try {
                if (this.writer.importRecord((Record)rec, this.timeout, this.timeUnit) || this.writer.getStatus() != IBuffer.Status.Open) break;
                log.warn("Consumer has timed out");
                continue;
            }
            catch (GRS2Exception e) {
                log.error("" + (Object)((Object)e));
                return;
            }
            finally {
                firstOutputStop = Calendar.getInstance().getTimeInMillis();
                try {
                    this.writer.close();
                }
                catch (GRS2WriterException e) {}
                continue;
            }
            break;
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closeStop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults((long)rc);
        this.stats.productionRate((float)rc / (float)(closeStop - start) * 1000.0f);
        log.info("GRS2Aggregator OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }

    private FieldDefinition[] initializeSchema() {
        ArrayList<Object> fieldDefsList = new ArrayList<Object>();
        if (this.filterMask == null) {
            this.filterMask = "[";
            for (FieldNaming.LocalFieldName localFieldName : FieldNaming.LocalFieldName.values()) {
                this.filterMask = this.filterMask + localFieldName.name() + ", ";
            }
            this.filterMask = this.filterMask.substring(0, this.filterMask.length() - 2);
            this.filterMask = this.filterMask + "]";
        }
        if (this.filterMask.replaceAll("[\\[\\],\\s]", "").matches("\\d*")) {
            for (String string : this.filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                int index = Integer.parseInt(string);
                if (index >= FieldNaming.LocalFieldName.values().length) {
                    log.warn("Filter mask out of range");
                    continue;
                }
                if (FieldNaming.LocalFieldName.values()[index].equals((Object)FieldNaming.LocalFieldName.bytestream)) {
                    fieldDefsList.add(new FileFieldDefinition(FieldNaming.LocalFieldName.values()[index].name()));
                    continue;
                }
                fieldDefsList.add(new StringFieldDefinition(FieldNaming.LocalFieldName.values()[index].name()));
            }
        } else {
            for (String string : this.filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                try {
                    switch (FieldNaming.LocalFieldName.valueOf(string)) {
                        case bytestream: {
                            FileFieldDefinition ffd = new FileFieldDefinition(FieldNaming.LocalFieldName.valueOf(string).name());
                            ffd.setDeleteOnDispose(true);
                            fieldDefsList.add(ffd);
                            break;
                        }
                        default: {
                            fieldDefsList.add(new StringFieldDefinition(FieldNaming.LocalFieldName.valueOf(string).name()));
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    log.warn("Filter mask out of range for value: " + string);
                }
            }
        }
        log.info("ResultSet schema that will be used: " + fieldDefsList);
        return fieldDefsList.toArray(new FieldDefinition[fieldDefsList.size()]);
    }
}

