/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.predefined;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.FileFieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.FieldNaming;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.contenttype.ContentTypeEvaluator;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.DataSource;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.predefined.URLParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPDataSource
extends DataSource {
    private static final String extensionSeparator = ".";
    private static Logger log = LoggerFactory.getLogger((String)FTPDataSource.class.getName());
    private FTPClient ftpClient = new FTPClient();
    private FTPListParseEngine engine;
    private String server;
    private int port;
    private String username = "anonymous";
    private String password = "anonymous";
    private String directory = "";

    public FTPDataSource(String input, Map<String, String> inputParameters) throws Exception {
        super(input, inputParameters);
        if (inputParameters != null) {
            this.filterMask = inputParameters.get("filterMask");
        }
        this.fieldDefs = FTPDataSource.initializeSchema(this.filterMask);
        URLParser parser = new URLParser(input);
        this.server = parser.getHostname();
        this.port = parser.getPort() == -1 ? this.ftpClient.getDefaultPort() : parser.getPort();
        this.directory = parser.getPath().startsWith("/") ? parser.getPath().substring(1) : parser.getPath();
        this.directory = this.directory.endsWith("/") ? this.directory : this.directory + "/";
        this.username = parser.getUsername() != null ? parser.getUsername() : this.username;
        this.password = parser.getPassword() != null ? parser.getPassword() : this.password;
        this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(this.fieldDefs)}, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        if (inputParameters != null && inputParameters.size() > 0) {
            for (Map.Entry<String, String> param : inputParameters.entrySet()) {
                if (param.getKey() != null && param.getKey().trim().length() > 0 && param.getValue() == null) continue;
            }
        }
        log.info("Ininializing ftp data source at: " + this.username + "@" + this.server + ":" + this.port + "/" + this.directory);
        this.ftpClient.connect(this.server, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
        log.info("Connected to " + this.server + extensionSeparator);
        log.info("FTP server replied: " + this.ftpClient.getReplyString());
        int replyCode = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            log.error("FTP server refused connection. Reply CODE: " + replyCode);
            this.ftpClient.disconnect();
            throw new Exception("FTP server refused connection. Reply CODE: " + replyCode);
        }
        this.engine = this.ftpClient.initiateListParsing(this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = Calendar.getInstance().getTimeInMillis();
        long firstInputStop = 0L;
        long firstOutputStop = 0L;
        int rc = 0;
        try {
            while (this.engine.hasNext()) {
                GenericRecord rec = this.retrieveFTPFile(this.engine.getNext(1)[0]);
                if (rec == null) continue;
                if (rc == 0) {
                    firstInputStop = Calendar.getInstance().getTimeInMillis();
                }
                if (!this.writer.importRecord((Record)rec, this.timeout, this.timeUnit)) {
                    if (this.writer.getStatus() == IBuffer.Status.Open) {
                        log.warn("Consumer has timed out");
                    }
                    break;
                }
                if (++rc != 1) continue;
                firstOutputStop = Calendar.getInstance().getTimeInMillis();
            }
        }
        catch (Exception e) {
            log.error("Error during datasource retrieval. Closing", (Throwable)e);
        }
        finally {
            try {
                this.writer.close();
                if (this.ftpClient.isConnected()) {
                    this.ftpClient.disconnect();
                }
            }
            catch (Exception ee) {}
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        log.info("DATASOURCE OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }

    private GenericRecord retrieveFTPFile(FTPFile file) {
        int tries = 0;
        while (true) {
            try {
                if (!file.isDirectory()) {
                    String remoteFileName = this.directory + file.getName();
                    log.debug("Returning next row with id: " + remoteFileName);
                    String extention = FTPDataSource.getFileExtention(file.getName());
                    ArrayList<Object> fieldList = new ArrayList<Object>();
                    block10: for (FieldDefinition field : this.fieldDefs) {
                        switch (FieldNaming.FTPFieldName.valueOf(field.getName())) {
                            case id: {
                                fieldList.add(new StringField(remoteFileName));
                                continue block10;
                            }
                            case bytestream: {
                                File localFile = null;
                                localFile = extention != null ? File.createTempFile("ftpDataSource", extensionSeparator + extention) : File.createTempFile("ftpDataSource", ".tmp");
                                localFile.deleteOnExit();
                                FileOutputStream outStream = new FileOutputStream(localFile);
                                this.ftpClient.retrieveFile(remoteFileName, (OutputStream)outStream);
                                outStream.close();
                                fieldList.add(new FileField(localFile));
                                continue block10;
                            }
                            case mimeType: {
                                fieldList.add(new StringField(ContentTypeEvaluator.getContentType(new File(remoteFileName))));
                                continue block10;
                            }
                            default: {
                                log.warn("Unexpected field: " + field.getName());
                            }
                        }
                    }
                    GenericRecord rec = new GenericRecord();
                    rec.setFields(fieldList.toArray(new Field[fieldList.size()]));
                    return rec;
                }
                return null;
            }
            catch (Exception e) {
                if (tries == 3) {
                    log.error("Did not manage to get next element...", (Throwable)e);
                    return null;
                }
                ++tries;
                log.error("Did not manage to get next element, reconnecting and trying again...", (Throwable)e);
                try {
                    log.debug("Trying to reconnect to the ftp");
                    this.reconnect();
                }
                catch (Exception e1) {
                    log.error("Could not reconnect to the server", (Throwable)e1);
                    return null;
                }
            }
        }
    }

    private void reconnect() throws Exception {
        this.ftpClient.connect(this.server, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
    }

    private static String getFileExtention(String fileName) {
        int dot = fileName.lastIndexOf(extensionSeparator);
        if (dot == -1) {
            return null;
        }
        return fileName.substring(dot + 1);
    }

    @Override
    public URI getLocator() {
        if (this.writer != null) {
            try {
                return this.writer.getLocator();
            }
            catch (GRS2WriterException e) {
                log.error("Could not retrieve locator", (Throwable)e);
            }
        }
        return null;
    }

    private static FieldDefinition[] initializeSchema(String filterMask) {
        ArrayList<Object> fieldDefsList = new ArrayList<Object>();
        if (filterMask == null) {
            filterMask = "[";
            for (FieldNaming.FTPFieldName fTPFieldName : FieldNaming.FTPFieldName.values()) {
                filterMask = filterMask + fTPFieldName.name() + ", ";
            }
            filterMask = filterMask.substring(0, filterMask.length() - 2);
            filterMask = filterMask + "]";
        }
        if (filterMask.replaceAll("[\\[\\],\\s]", "").matches("\\d*")) {
            for (String string : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                int index = Integer.parseInt(string);
                if (index >= FieldNaming.FTPFieldName.values().length) {
                    log.warn("Filter mask out of range");
                    continue;
                }
                if (FieldNaming.FTPFieldName.values()[index].equals((Object)FieldNaming.FTPFieldName.bytestream)) {
                    FileFieldDefinition fd = new FileFieldDefinition(FieldNaming.FTPFieldName.values()[index].name());
                    fd.setDeleteOnDispose(true);
                    fieldDefsList.add(fd);
                    continue;
                }
                fieldDefsList.add(new StringFieldDefinition(FieldNaming.FTPFieldName.values()[index].name()));
            }
        } else {
            for (String string : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
                try {
                    switch (FieldNaming.FTPFieldName.valueOf(string)) {
                        case bytestream: {
                            fieldDefsList.add(new FileFieldDefinition(FieldNaming.FTPFieldName.valueOf(string).name()));
                            break;
                        }
                        default: {
                            fieldDefsList.add(new StringFieldDefinition(FieldNaming.FTPFieldName.valueOf(string).name()));
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    log.warn("Filter mask out of range for value: " + string);
                }
            }
        }
        log.info("ResultSet schema that will be used: " + fieldDefsList);
        return fieldDefsList.toArray(new FieldDefinition[fieldDefsList.size()]);
    }

    public static void main(String[] args) throws URISyntaxException {
        ArrayList<String> strs = new ArrayList<String>();
        strs.add("foo://username:password@example.com:8042/over/there/index.dtb?type=animal&name=narwhal#nose");
        strs.add("ftp://giannis:aplagiaftp@meteora.di.uoa.gr");
        strs.add("ftp://giannis:aplagiaftp@meteora.di.uoa.gr:1234/testArea/src");
        strs.add("ftp://giannis:password@meteora.di.uoa.gr:1234/testArea/src");
        strs.add("ftp://giannis:aplagiaftp@meteora.di.uoa.gr/testArea/src");
        ArrayList<URLParser> list = new ArrayList<URLParser>();
        for (String str : strs) {
            list.add(new URLParser(str));
        }
        for (URLParser l : list) {
            System.out.println("user: " + l.getUsername());
            System.out.println("pass: " + l.getPassword());
            System.out.println("host: " + l.getHostname());
            System.out.println("port: " + l.getPort());
            System.out.println("path: " + l.getPath());
            System.out.println("---------------------------------");
        }
    }
}

