/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.gcube.datatransformation.client.library.beans.Types;
import org.gcube.datatransformation.client.library.exceptions.DTSClientException;
import org.gcube.datatransformation.client.library.exceptions.DTSException;
import org.gcube.datatransformation.client.library.exceptions.EmptySourceException;
import org.gcube.datatransformation.rest.commons.DataTransformationDiscoverer;
import org.gcube.datatransformation.rest.commons.DataTransformationDiscovererAPI;
import org.gcube.datatransformation.rest.commons.DataTransformationServiceAPI;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.is.discoverer.ri.icclient.RIDiscovererISimpl;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransformationClient {
    private static final Logger logger = LoggerFactory.getLogger(DataTransformationClient.class);
    private Gson gson = new Gson();
    private String scope;
    private String endpoint;
    private DataTransformationDiscovererAPI dataTransformationDiscoverer;

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
        this.dataTransformationDiscoverer = new DataTransformationDiscoverer((RunningInstancesDiscoverer)new RIDiscovererISimpl());
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void initializeClient(String endpoint) {
        this.endpoint = endpoint;
    }

    public void randomClient() throws DTSClientException {
        Random random = new Random();
        Set ris = this.dataTransformationDiscoverer.discoverDataTransformationRunninInstances(this.scope);
        if (ris == null || ris.size() == 0) {
            throw new DTSClientException("No data transformation endopoints found in scope: " + this.scope);
        }
        ArrayList dataTransformationServices = new ArrayList(ris);
        this.endpoint = (String)dataTransformationServices.get(random.nextInt(dataTransformationServices.size()));
    }

    public String statistics() throws DTSException {
        DataTransformationServiceAPI simple = this.getDTSClient();
        Response response = null;
        response = simple.statistics(this.scope);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String xml = (String)response.readEntity(String.class);
        response.close();
        return xml;
    }

    public Types.TransformDataResponse transformData(Types.TransformData request) throws DTSException {
        DataTransformationServiceAPI simple = this.getDTSClient();
        Response response = null;
        response = simple.transformData(this.scope, this.gson.toJson((Object)request.input), this.gson.toJson((Object)request.targetContentType), this.gson.toJson((Object)request.output), request.createReport.toString(), Boolean.valueOf(false), Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        return (Types.TransformDataResponse)this.gson.fromJson(json, Types.TransformDataResponse.class);
    }

    public Types.TransformDataWithTransformationProgramResponse transformDataWithTransformationProgram(Types.TransformDataWithTransformationProgram request) throws DTSException {
        DataTransformationServiceAPI simple = this.getDTSClient();
        Response response = null;
        response = simple.transformDataWithTransformationProgram(this.scope, this.gson.toJson((Object)request.input), this.gson.toJson((Object)request.tpID), this.gson.toJson((Object)request.targetContentType), this.gson.toJson(request.tProgramUnboundParameters), this.gson.toJson((Object)request.output), request.createReport.toString(), Boolean.valueOf(false), Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        return (Types.TransformDataWithTransformationProgramResponse)this.gson.fromJson(json, Types.TransformDataWithTransformationProgramResponse.class);
    }

    public Types.TransformDataWithTransformationUnitResponse transformDataWithTransformationUnit(Types.TransformDataWithTransformationUnit request) throws DTSException, EmptySourceException {
        String json = this.transformDataWithTransformationUnit(request, false, false);
        return (Types.TransformDataWithTransformationUnitResponse)this.gson.fromJson(json, Types.TransformDataWithTransformationUnitResponse.class);
    }

    public static List<Map<String, String>> getMapFromResponse(String json) {
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        ArrayList<Map<String, String>> messages = new ArrayList<Map<String, String>>();
        try {
            reader.beginArray();
            while (reader.hasNext()) {
                Map message = (Map)new Gson().fromJson(reader, new HashMap().getClass());
                messages.add(message);
            }
            reader.endArray();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return messages;
    }

    public String transformDataWithTransformationUnit(Types.TransformDataWithTransformationUnit request, boolean all, boolean pretty) throws DTSException, EmptySourceException {
        DataTransformationServiceAPI simple = this.getDTSClient();
        Response response = null;
        response = simple.transformDataWithTransformationUnit(this.scope, this.gson.toJson(request.inputs), this.gson.toJson((Object)request.tpID), this.gson.toJson((Object)request.transformationUnitID), this.gson.toJson((Object)request.targetContentType), this.gson.toJson(request.tProgramUnboundParameters), this.gson.toJson((Object)request.output), request.filterSources.toString(), request.createReport.toString(), Boolean.valueOf(all), Boolean.valueOf(pretty));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            EmptySourceException e1 = null;
            try {
                response.close();
                logger.error("response error: " + error);
                JsonObject obj = (JsonObject)new JsonParser().parse(error);
                obj.get("exception").getAsJsonObject().get("class").getAsString();
                obj.get("exception").getAsJsonObject().get("message").getAsString();
                e1 = (EmptySourceException)Class.forName(obj.get("exception").getAsJsonObject().get("class").getAsString()).getConstructor(String.class).newInstance(obj.get("exception").getAsJsonObject().get("message").getAsString());
            }
            catch (Exception e) {
                response.close();
                logger.error("response error: " + error);
                throw new DTSException("response error: " + error);
            }
            throw e1;
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        return json;
    }

    public Types.FindApplicableTransformationUnitsResponse findApplicableTransformationUnits(Types.FindApplicableTransformationUnits request) throws DTSException {
        DataTransformationServiceAPI simple = this.getDTSClient();
        Response response = null;
        response = simple.findApplicableTransformationUnits(this.scope, this.gson.toJson((Object)request.sourceContentType), this.gson.toJson((Object)request.targetContentType), this.gson.toJson((Object)request.createAndPublishCompositeTP), Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        return (Types.FindApplicableTransformationUnitsResponse)this.gson.fromJson(json, Types.FindApplicableTransformationUnitsResponse.class);
    }

    public Types.FindAvailableTargetContentTypesResponse findAvailableTargetContent(Types.FindAvailableTargetContentTypes request) throws DTSException {
        DataTransformationServiceAPI simple = this.getDTSClient();
        Response response = null;
        response = simple.findAvailableTargetContentTypes(this.scope, this.gson.toJson((Object)request.sourceContentType), Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        return (Types.FindAvailableTargetContentTypesResponse)this.gson.fromJson(json, Types.FindAvailableTargetContentTypesResponse.class);
    }

    public Types.QueryTransformationProgramsResponse queryTransformationPrograms(Types.QueryTransformationPrograms request) throws DTSException {
        DataTransformationServiceAPI simple = this.getDTSClient();
        Response response = null;
        response = simple.queryTransformationPrograms(this.scope, request.queryTransformationPrograms, Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        Types.QueryTransformationProgramsResponse queryTransformationProgramsResponse = new Types.QueryTransformationProgramsResponse();
        queryTransformationProgramsResponse.queryTransformationProgramsResponse = json;
        return queryTransformationProgramsResponse;
    }

    private DataTransformationServiceAPI getDTSClient() throws DTSException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            return (DataTransformationServiceAPI)target.proxy(DataTransformationServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint: " + this.endpoint, (Throwable)e);
            throw new DTSException("Client could not connect to endpoint: " + this.endpoint, (Throwable)e);
        }
    }
}

