/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.elasticsearch.loaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class TitleSnippet {
    private static final String TITLE_SNIPPET_FOLDER = "title_snippet/";
    private static Map<String, Properties> titleSnippetProps;
    private static boolean isInit;
    private static final Logger logger;

    public static synchronized void init() {
        titleSnippetProps = new ConcurrentHashMap<String, Properties>();
        URL titleSnippetUrl = Thread.currentThread().getContextClassLoader().getResource(TITLE_SNIPPET_FOLDER);
        URI titleSnippetFilePath = null;
        if (titleSnippetUrl != null) {
            try {
                titleSnippetFilePath = titleSnippetUrl.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (titleSnippetFilePath != null) {
            File dir = new File(titleSnippetFilePath);
            if (dir.exists() && dir.isDirectory()) {
                for (File file : dir.listFiles()) {
                    try {
                        titleSnippetProps.put(file.getName().replace(".properties", ""), TitleSnippet.readProperties(file.toURI()));
                    }
                    catch (IOException e) {
                        logger.info((Object)"Could not load a properties file");
                    }
                }
            }
            logger.debug((Object)("Found " + titleSnippetProps.size() + " titleSnippet files in the classpath"));
        } else {
            logger.error((Object)("Could not load the folder containing the title-snippet mappings... No " + titleSnippetUrl + " folder found within the classpath."));
        }
    }

    public static Map<String, Properties> getAllTitleSnippets() {
        if (!isInit) {
            TitleSnippet.init();
        }
        return titleSnippetProps;
    }

    private static synchronized Properties readProperties(URI path) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(new File(path)));
        return props;
    }

    static {
        isInit = false;
        logger = Logger.getLogger(TitleSnippet.class);
    }
}

