/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListGroupsServlet
extends HttpServlet {
    public static final String GROUP_NAME = "groupName";
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(ListGroupsServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Servlet ListGroupsServlet called ......");
        String message = "";
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        try {
            try {
                session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
                List groups = this.listGroups(session);
                XStream xstream = new XStream();
                String xmlConfig = xstream.toXML((Object)groups);
                out.println(xmlConfig);
            }
            catch (RepositoryException e) {
                message = e.getMessage();
                response.setContentLength(message.length());
                out.println(message);
                if (session != null) {
                    session.logout();
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }

    private List<String> listGroups(SessionImpl jcrsession) throws AccessDeniedException, RepositoryException {
        UserManager userManager = jcrsession.getUserManager();
        ArrayList<String> groups = new ArrayList<String>();
        Iterator iter = userManager.findAuthorizables("jcr:primaryType", "rep:Group");
        while (iter.hasNext()) {
            Authorizable auth = (Authorizable)iter.next();
            if (!auth.isGroup() || auth.getID().equals("UserAdmin") || auth.getID().equals("GroupAdmin") || auth.getID().equals("administrators")) continue;
            groups.add(auth.getID());
        }
        if (!userManager.isAutoSave()) {
            jcrsession.save();
        }
        return groups;
    }
}

