/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.j2ee.workspacemanager.accounting.JCRAccountingEntry;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRAccountingEntryShare
extends JCRAccountingEntry {
    protected String itemName;
    protected List<String> members;
    protected static Logger logger = LoggerFactory.getLogger(JCRAccountingEntryShare.class);

    public JCRAccountingEntryShare(Node node) throws RepositoryException {
        super(node);
        String itemName = node.getProperty(AccountingProperty.ITEM_NAME.toString()).getString();
        ArrayList<String> members = new ArrayList<String>();
        Value[] valueArray = node.getProperty(AccountingProperty.MEMBERS.toString()).getValues();
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (v != null) {
                members.add(v.getString());
            }
            ++n2;
        }
        HashMap<AccountingProperty, String> map = new HashMap<AccountingProperty, String>();
        map.put(AccountingProperty.ITEM_NAME, new XStream().toXML((Object)itemName));
        map.put(AccountingProperty.MEMBERS, new XStream().toXML(members));
        this.item.setAccountingProperties(map);
    }
}

