/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceFolder;
import org.gcube.common.homelibary.model.items.type.NodeProperty;

public class JCRWorkspaceSharedFolder
extends JCRWorkspaceFolder {
    public JCRWorkspaceSharedFolder(Node node, String login) throws RepositoryException {
        super(node, login);
        try {
            this.properties.put(NodeProperty.MEMBERS, this.xstream.toXML((Object)this.getMembers(node)));
        }
        catch (Exception e) {
            logger.info(NodeProperty.MEMBERS + " not present");
        }
        try {
            this.properties.put(NodeProperty.USERS, this.xstream.toXML((Object)this.getUsers(node)));
        }
        catch (Exception e) {
            logger.info(NodeProperty.USERS + " not present");
        }
        if (node.hasProperty(NodeProperty.IS_VRE_FOLDER.toString())) {
            this.properties.put(NodeProperty.IS_VRE_FOLDER, this.xstream.toXML((Object)node.getProperty(NodeProperty.IS_VRE_FOLDER.toString()).getBoolean()));
        }
        if (node.hasProperty(NodeProperty.DISPLAY_NAME.toString())) {
            this.properties.put(NodeProperty.DISPLAY_NAME, node.getProperty(NodeProperty.DISPLAY_NAME.toString()).getString());
        }
    }

    private Map<String, String> getUsers(Node node) throws RepositoryException {
        HashMap<String, String> list = new HashMap<String, String>();
        try {
            Node usersNode = node.getNode(NodeProperty.USERS.toString());
            PropertyIterator iterator = usersNode.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                String key = property.getName();
                String value = property.getString();
                if (key.startsWith("jcr:") || key.startsWith("hl:") || key.startsWith("nt:")) continue;
                list.put(key, value);
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        return list;
    }

    public List<String> getMembers(Node node) throws RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Node members = node.getNode(NodeProperty.MEMBERS.toString());
            NodeIterator children = members.getNodes();
            while (children.hasNext()) {
                String name = children.nextNode().getName();
                if (name.startsWith("jcr:") || name.startsWith("hl:")) continue;
                list.add(name);
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        return list;
    }
}

